/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.spi;

import java.util.Objects;
import org.infinispan.metadata.Metadata;

public class SiteEntry<V> {
    private final String siteName;
    private final V value;
    private final Metadata metadata;

    public SiteEntry(String siteName, V value, Metadata metadata) {
        this.siteName = Objects.requireNonNull(siteName, "Site Name must be non-null");
        this.value = value;
        this.metadata = metadata;
    }

    public String getSiteName() {
        return this.siteName;
    }

    public V getValue() {
        return this.value;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SiteEntry siteEntry = (SiteEntry)o;
        return this.siteName.equals(siteEntry.siteName) && Objects.equals(this.value, siteEntry.value) && Objects.equals(this.metadata, siteEntry.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.siteName, this.value, this.metadata);
    }

    public String toString() {
        return "SiteEntry{siteName='" + this.siteName + '\'' + ", value=" + this.value + ", metadata=" + this.metadata + '}';
    }
}

