/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpClientUpgradeHandler;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.EventExecutor;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.GoAway;
import io.vertx.core.http.Http2Settings;
import io.vertx.core.http.HttpConnection;
import io.vertx.core.http.HttpFrame;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.StreamPriority;
import io.vertx.core.http.impl.Http1xClientConnection;
import io.vertx.core.http.impl.Http2ClientConnection;
import io.vertx.core.http.impl.HttpClientConnection;
import io.vertx.core.http.impl.HttpClientImpl;
import io.vertx.core.http.impl.HttpClientPush;
import io.vertx.core.http.impl.HttpClientStream;
import io.vertx.core.http.impl.HttpRequestHead;
import io.vertx.core.http.impl.HttpResponseHead;
import io.vertx.core.http.impl.VertxHttp2ClientUpgradeCodec;
import io.vertx.core.http.impl.VertxHttp2ConnectionHandler;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.EventLoopContext;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.impl.clientconnection.ConnectionListener;
import java.util.ArrayDeque;
import java.util.Deque;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.security.cert.X509Certificate;

public class Http2UpgradedClientConnection
implements HttpClientConnection {
    private static final Object SEND_BUFFERED_MESSAGES = new Object();
    private static final Logger log = LoggerFactory.getLogger(Http2UpgradedClientConnection.class);
    private HttpClientImpl client;
    private HttpClientConnection current;
    private Handler<Void> closeHandler;
    private Handler<Void> shutdownHandler;
    private Handler<GoAway> goAwayHandler;
    private Handler<Throwable> exceptionHandler;
    private Handler<Buffer> pingHandler;
    private Handler<Http2Settings> remoteSettingsHandler;

    Http2UpgradedClientConnection(HttpClientImpl client, Http1xClientConnection connection) {
        this.client = client;
        this.current = connection;
    }

    @Override
    public ChannelHandlerContext channelHandlerContext() {
        return this.current.channelHandlerContext();
    }

    @Override
    public Channel channel() {
        return this.current.channel();
    }

    @Override
    public Future<Void> close() {
        return this.current.close();
    }

    @Override
    public Object metric() {
        return this.current.metric();
    }

    @Override
    public void createStream(ContextInternal context, Handler<AsyncResult<HttpClientStream>> handler) {
        if (this.current instanceof Http1xClientConnection) {
            this.current.createStream(context, ar -> {
                if (ar.succeeded()) {
                    HttpClientStream stream = (HttpClientStream)ar.result();
                    UpgradingStream upgradingStream = new UpgradingStream(stream, (Http1xClientConnection)this.current);
                    handler.handle(Future.succeededFuture(upgradingStream));
                } else {
                    handler.handle((AsyncResult<HttpClientStream>)ar);
                }
            });
        } else {
            this.current.createStream(context, handler);
        }
    }

    @Override
    public ContextInternal getContext() {
        return this.current.getContext();
    }

    @Override
    public HttpConnection closeHandler(Handler<Void> handler) {
        this.closeHandler = handler;
        this.current.closeHandler(handler);
        return this;
    }

    @Override
    public HttpConnection exceptionHandler(Handler<Throwable> handler) {
        this.exceptionHandler = handler;
        this.current.exceptionHandler(handler);
        return this;
    }

    @Override
    public HttpConnection remoteSettingsHandler(Handler<Http2Settings> handler) {
        if (this.current instanceof Http1xClientConnection) {
            this.remoteSettingsHandler = handler;
        } else {
            this.current.remoteSettingsHandler(handler);
        }
        return this;
    }

    @Override
    public HttpConnection pingHandler(@Nullable Handler<Buffer> handler) {
        if (this.current instanceof Http1xClientConnection) {
            this.pingHandler = handler;
        } else {
            this.current.pingHandler(handler);
        }
        return this;
    }

    @Override
    public HttpConnection goAwayHandler(@Nullable Handler<GoAway> handler) {
        if (this.current instanceof Http1xClientConnection) {
            this.goAwayHandler = handler;
        } else {
            this.current.goAwayHandler(handler);
        }
        return this;
    }

    @Override
    public HttpConnection shutdownHandler(@Nullable Handler<Void> handler) {
        if (this.current instanceof Http1xClientConnection) {
            this.shutdownHandler = handler;
        } else {
            this.current.shutdownHandler(handler);
        }
        return this;
    }

    @Override
    public HttpConnection goAway(long errorCode, int lastStreamId, Buffer debugData) {
        return this.current.goAway(errorCode, lastStreamId, debugData);
    }

    @Override
    public void shutdown(long timeout, Handler<AsyncResult<Void>> handler) {
        this.current.shutdown(timeout, handler);
    }

    @Override
    public Future<Void> shutdown(long timeoutMs) {
        return this.current.shutdown(timeoutMs);
    }

    @Override
    public Future<Void> updateSettings(Http2Settings settings) {
        return this.current.updateSettings(settings);
    }

    @Override
    public HttpConnection updateSettings(Http2Settings settings, Handler<AsyncResult<Void>> completionHandler) {
        return this.current.updateSettings(settings, completionHandler);
    }

    @Override
    public Http2Settings settings() {
        return this.current.settings();
    }

    @Override
    public Http2Settings remoteSettings() {
        return this.current.remoteSettings();
    }

    @Override
    public HttpConnection ping(Buffer data, Handler<AsyncResult<Buffer>> pongHandler) {
        return this.current.ping(data, pongHandler);
    }

    @Override
    public Future<Buffer> ping(Buffer data) {
        return this.current.ping(data);
    }

    @Override
    public SocketAddress remoteAddress() {
        return this.current.remoteAddress();
    }

    @Override
    public SocketAddress localAddress() {
        return this.current.localAddress();
    }

    @Override
    public boolean isSsl() {
        return this.current.isSsl();
    }

    @Override
    public SSLSession sslSession() {
        return this.current.sslSession();
    }

    @Override
    public X509Certificate[] peerCertificateChain() throws SSLPeerUnverifiedException {
        return this.current.peerCertificateChain();
    }

    @Override
    public boolean isValid() {
        return this.current.isValid();
    }

    @Override
    public String indicatedServerName() {
        return this.current.indicatedServerName();
    }

    private class UpgradingStream
    implements HttpClientStream {
        private final Http1xClientConnection conn;
        private final HttpClientStream stream;
        private Handler<HttpResponseHead> headHandler;
        private Handler<Buffer> chunkHandler;
        private Handler<MultiMap> endHandler;
        private Handler<StreamPriority> priorityHandler;
        private Handler<Throwable> exceptionHandler;
        private Handler<Void> drainHandler;
        private Handler<Void> continueHandler;
        private Handler<HttpClientPush> pushHandler;
        private Handler<HttpFrame> unknownFrameHandler;
        private HttpClientStream upgradedStream;

        UpgradingStream(HttpClientStream stream, Http1xClientConnection conn) {
            this.conn = conn;
            this.stream = stream;
        }

        @Override
        public HttpClientConnection connection() {
            return Http2UpgradedClientConnection.this;
        }

        @Override
        public void writeHead(HttpRequestHead request, boolean chunked, ByteBuf buf, boolean end, StreamPriority priority, boolean connect, Handler<AsyncResult<Void>> handler) {
            final ChannelPipeline pipeline = this.conn.channel().pipeline();
            HttpClientCodec httpCodec = (HttpClientCodec)pipeline.get(HttpClientCodec.class);
            VertxHttp2ClientUpgradeCodec upgradeCodec = new VertxHttp2ClientUpgradeCodec(Http2UpgradedClientConnection.this.client.getOptions().getInitialSettings()){

                @Override
                public void upgradeTo(ChannelHandlerContext ctx, FullHttpResponse upgradeResponse) throws Exception {
                    ConnectionListener<HttpClientConnection> listener = UpgradingStream.this.conn.listener();
                    VertxHttp2ConnectionHandler<Http2ClientConnection> handler = Http2ClientConnection.createHttp2ConnectionHandler(Http2UpgradedClientConnection.this.client, ((UpgradingStream)UpgradingStream.this).conn.metrics, listener, (EventLoopContext)UpgradingStream.this.conn.getContext(), Http2UpgradedClientConnection.this.current.metric(), (conn, concurrency) -> conn.upgradeStream(UpgradingStream.this.stream.metric(), UpgradingStream.this.stream.getContext(), ar -> {
                        UpgradingStream.this.conn.closeHandler((Handler)null);
                        UpgradingStream.this.conn.exceptionHandler((Handler)null);
                        if (ar.succeeded()) {
                            UpgradingStream.this.upgradedStream = (HttpClientStream)ar.result();
                            UpgradingStream.this.upgradedStream.headHandler(UpgradingStream.this.headHandler);
                            UpgradingStream.this.upgradedStream.chunkHandler(UpgradingStream.this.chunkHandler);
                            UpgradingStream.this.upgradedStream.endHandler(UpgradingStream.this.endHandler);
                            UpgradingStream.this.upgradedStream.priorityHandler(UpgradingStream.this.priorityHandler);
                            UpgradingStream.this.upgradedStream.exceptionHandler(UpgradingStream.this.exceptionHandler);
                            UpgradingStream.this.upgradedStream.drainHandler(UpgradingStream.this.drainHandler);
                            UpgradingStream.this.upgradedStream.continueHandler(UpgradingStream.this.continueHandler);
                            UpgradingStream.this.upgradedStream.pushHandler(UpgradingStream.this.pushHandler);
                            UpgradingStream.this.upgradedStream.unknownFrameHandler(UpgradingStream.this.unknownFrameHandler);
                            UpgradingStream.this.stream.headHandler(null);
                            UpgradingStream.this.stream.chunkHandler(null);
                            UpgradingStream.this.stream.endHandler(null);
                            UpgradingStream.this.stream.priorityHandler(null);
                            UpgradingStream.this.stream.exceptionHandler(null);
                            UpgradingStream.this.stream.drainHandler(null);
                            UpgradingStream.this.stream.continueHandler(null);
                            UpgradingStream.this.stream.pushHandler(null);
                            UpgradingStream.this.stream.unknownFrameHandler(null);
                            UpgradingStream.this.headHandler = null;
                            UpgradingStream.this.chunkHandler = null;
                            UpgradingStream.this.endHandler = null;
                            UpgradingStream.this.priorityHandler = null;
                            UpgradingStream.this.exceptionHandler = null;
                            UpgradingStream.this.drainHandler = null;
                            UpgradingStream.this.continueHandler = null;
                            UpgradingStream.this.pushHandler = null;
                            Http2UpgradedClientConnection.this.current = conn;
                            conn.closeHandler(Http2UpgradedClientConnection.this.closeHandler);
                            conn.exceptionHandler(UpgradingStream.this.exceptionHandler);
                            conn.pingHandler(Http2UpgradedClientConnection.this.pingHandler);
                            conn.goAwayHandler(Http2UpgradedClientConnection.this.goAwayHandler);
                            conn.shutdownHandler(Http2UpgradedClientConnection.this.shutdownHandler);
                            conn.remoteSettingsHandler(Http2UpgradedClientConnection.this.remoteSettingsHandler);
                            listener.onConcurrencyChange((long)concurrency);
                        } else {
                            log.error(ar.cause().getMessage(), ar.cause());
                        }
                    }));
                    UpgradingStream.this.conn.channel().pipeline().addLast(new ChannelHandler[]{handler});
                    handler.clientUpgrade(ctx);
                }
            };
            HttpClientUpgradeHandler upgradeHandler = new HttpClientUpgradeHandler((HttpClientUpgradeHandler.SourceCodec)httpCodec, upgradeCodec, 65536){
                private long bufferedSize;
                private Deque<Object> buffered;
                {
                    this.bufferedSize = 0L;
                    this.buffered = new ArrayDeque<Object>();
                }

                public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                    if (this.buffered != null) {
                        boolean lower;
                        int maxContent = this.maxContentLength();
                        boolean bl = lower = this.bufferedSize < (long)maxContent;
                        if (msg instanceof ByteBufHolder) {
                            this.bufferedSize += (long)((ByteBufHolder)msg).content().readableBytes();
                        } else if (msg instanceof ByteBuf) {
                            this.bufferedSize += (long)((ByteBuf)msg).readableBytes();
                        }
                        this.buffered.add(msg);
                        if (this.bufferedSize >= (long)maxContent && lower) {
                            ctx.fireExceptionCaught((Throwable)new TooLongFrameException("Max content exceeded " + this.maxContentLength() + " bytes."));
                        }
                    } else {
                        super.channelRead(ctx, msg);
                    }
                }

                public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
                    if (SEND_BUFFERED_MESSAGES == evt) {
                        Object msg;
                        Deque<Object> messages = this.buffered;
                        this.buffered = null;
                        while ((msg = messages.poll()) != null) {
                            super.channelRead(ctx, msg);
                        }
                    } else {
                        super.userEventTriggered(ctx, evt);
                    }
                }

                public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
                    if (this.buffered != null) {
                        Object msg;
                        Deque<Object> messages = this.buffered;
                        this.buffered = null;
                        while ((msg = messages.poll()) != null) {
                            ReferenceCountUtil.release((Object)msg);
                        }
                    }
                    super.handlerRemoved(ctx);
                }
            };
            class UpgradeRequestHandler
            extends ChannelInboundHandlerAdapter {
                UpgradeRequestHandler() {
                }

                public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
                    super.userEventTriggered(ctx, evt);
                    ChannelPipeline pipeline2 = ctx.pipeline();
                    if (evt == HttpClientUpgradeHandler.UpgradeEvent.UPGRADE_SUCCESSFUL) {
                        pipeline2.remove(UpgradingStream.this.conn.channelHandlerContext().handler());
                    }
                }

                public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                    if (msg instanceof HttpResponseHead) {
                        pipeline.remove((ChannelHandler)this);
                        HttpResponseHead resp = (HttpResponseHead)msg;
                        if (resp.statusCode != HttpResponseStatus.SWITCHING_PROTOCOLS.code()) {
                            resp.headers.set((CharSequence)HttpHeaderNames.CONNECTION, (CharSequence)HttpHeaderValues.CLOSE);
                        }
                    }
                    super.channelRead(ctx, msg);
                }
            }
            pipeline.addAfter("codec", null, (ChannelHandler)new UpgradeRequestHandler());
            pipeline.addAfter("codec", null, (ChannelHandler)upgradeHandler);
            this.doWriteHead(request, chunked, buf, end, priority, connect, handler);
        }

        private void doWriteHead(HttpRequestHead head, boolean chunked, ByteBuf buf, boolean end, StreamPriority priority, boolean connect, Handler<AsyncResult<Void>> handler) {
            EventExecutor exec = this.conn.channelHandlerContext().executor();
            if (exec.inEventLoop()) {
                this.stream.writeHead(head, chunked, buf, end, priority, connect, handler);
                if (end) {
                    ChannelPipeline pipeline = this.conn.channelHandlerContext().pipeline();
                    pipeline.fireUserEventTriggered(SEND_BUFFERED_MESSAGES);
                }
            } else {
                exec.execute(() -> this.doWriteHead(head, chunked, buf, end, priority, connect, handler));
            }
        }

        @Override
        public int id() {
            return 1;
        }

        @Override
        public Object metric() {
            return this.stream.metric();
        }

        @Override
        public HttpVersion version() {
            HttpClientStream s = this.upgradedStream;
            if (s == null) {
                s = this.stream;
            }
            return s.version();
        }

        @Override
        public ContextInternal getContext() {
            return this.stream.getContext();
        }

        @Override
        public void continueHandler(Handler<Void> handler) {
            if (this.upgradedStream != null) {
                this.upgradedStream.continueHandler(handler);
            } else {
                this.stream.continueHandler(handler);
                this.continueHandler = handler;
            }
        }

        @Override
        public void pushHandler(Handler<HttpClientPush> handler) {
            if (this.pushHandler != null) {
                this.upgradedStream.pushHandler(handler);
            } else {
                this.stream.pushHandler(handler);
                this.pushHandler = handler;
            }
        }

        @Override
        public void drainHandler(Handler<Void> handler) {
            if (this.upgradedStream != null) {
                this.upgradedStream.drainHandler(handler);
            } else {
                this.stream.drainHandler(handler);
                this.drainHandler = handler;
            }
        }

        @Override
        public void exceptionHandler(Handler<Throwable> handler) {
            if (this.upgradedStream != null) {
                this.upgradedStream.exceptionHandler(handler);
            } else {
                this.stream.exceptionHandler(handler);
                this.exceptionHandler = handler;
            }
        }

        @Override
        public void headHandler(Handler<HttpResponseHead> handler) {
            if (this.upgradedStream != null) {
                this.upgradedStream.headHandler(handler);
            } else {
                this.stream.headHandler(handler);
                this.headHandler = handler;
            }
        }

        @Override
        public void chunkHandler(Handler<Buffer> handler) {
            if (this.upgradedStream != null) {
                this.upgradedStream.chunkHandler(handler);
            } else {
                this.stream.chunkHandler(handler);
                this.chunkHandler = handler;
            }
        }

        @Override
        public void endHandler(Handler<MultiMap> handler) {
            if (this.upgradedStream != null) {
                this.upgradedStream.endHandler(handler);
            } else {
                this.stream.endHandler(handler);
                this.endHandler = handler;
            }
        }

        @Override
        public void unknownFrameHandler(Handler<HttpFrame> handler) {
            if (this.upgradedStream != null) {
                this.upgradedStream.unknownFrameHandler(handler);
            } else {
                this.stream.unknownFrameHandler(handler);
                this.unknownFrameHandler = handler;
            }
        }

        @Override
        public void priorityHandler(Handler<StreamPriority> handler) {
            if (this.upgradedStream != null) {
                this.upgradedStream.priorityHandler(handler);
            } else {
                this.stream.priorityHandler(handler);
                this.priorityHandler = handler;
            }
        }

        @Override
        public void writeBuffer(ByteBuf buf, boolean end, Handler<AsyncResult<Void>> handler) {
            EventExecutor exec = this.conn.channelHandlerContext().executor();
            if (exec.inEventLoop()) {
                this.stream.writeBuffer(buf, end, handler);
                if (end) {
                    ChannelPipeline pipeline = this.conn.channelHandlerContext().pipeline();
                    pipeline.fireUserEventTriggered(SEND_BUFFERED_MESSAGES);
                }
            } else {
                exec.execute(() -> this.writeBuffer(buf, end, handler));
            }
        }

        @Override
        public void writeFrame(int type, int flags, ByteBuf payload) {
            this.stream.writeFrame(type, flags, payload);
        }

        @Override
        public void doSetWriteQueueMaxSize(int size) {
            this.stream.doSetWriteQueueMaxSize(size);
        }

        @Override
        public boolean isNotWritable() {
            return this.stream.isNotWritable();
        }

        @Override
        public void doPause() {
            this.stream.doPause();
        }

        @Override
        public void doFetch(long amount) {
            this.stream.doFetch(amount);
        }

        @Override
        public void reset(Throwable cause) {
            this.stream.reset(cause);
        }

        @Override
        public StreamPriority priority() {
            return this.stream.priority();
        }

        @Override
        public void updatePriority(StreamPriority streamPriority) {
            this.stream.updatePriority(streamPriority);
        }
    }
}

