/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.SSLEngineOptions;
import javax.net.ssl.SSLEngine;

@DataObject
public class JdkSSLEngineOptions
extends SSLEngineOptions {
    private static Boolean jdkAlpnAvailable;

    public static synchronized boolean isAlpnAvailable() {
        if (jdkAlpnAvailable == null) {
            boolean available = false;
            try {
                SSLEngine.class.getDeclaredMethod("getApplicationProtocol", new Class[0]);
                available = true;
            }
            catch (Exception ignore1) {
                try {
                    JdkSSLEngineOptions.class.getClassLoader().loadClass("sun.security.ssl.ALPNExtension");
                    available = true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            finally {
                jdkAlpnAvailable = available;
            }
        }
        return jdkAlpnAvailable;
    }

    public JdkSSLEngineOptions() {
    }

    public JdkSSLEngineOptions(JsonObject json) {
    }

    public JdkSSLEngineOptions(JdkSSLEngineOptions that) {
    }

    public JsonObject toJson() {
        return new JsonObject();
    }

    @Override
    public JdkSSLEngineOptions copy() {
        return new JdkSSLEngineOptions();
    }
}

