/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers.ifelse;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandLineException;
import org.jboss.as.cli.CommandLineRedirection;
import org.jboss.as.cli.batch.BatchManager;
import org.jboss.as.cli.handlers.ifelse.Operation;
import org.jboss.as.cli.operation.ParsedCommandLine;
import org.jboss.as.cli.parsing.command.CommandFormat;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;
import org.wildfly.common.Assert;

class IfElseControlFlow
implements CommandLineRedirection {
    private static final String CTX_KEY = "IF";
    private CommandLineRedirection.Registration registration;
    private final Operation ifCondition;
    private final ModelNode ifRequest;
    private List<String> ifBlock;
    private List<String> elseBlock;
    private boolean inElse;

    static IfElseControlFlow get(CommandContext ctx) {
        return (IfElseControlFlow)ctx.get(CommandContext.Scope.CONTEXT, CTX_KEY);
    }

    IfElseControlFlow(CommandContext ctx, Operation ifCondition, String ifRequest) throws CommandLineException {
        Assert.checkNotNullParam((String)"ctx", (Object)ctx);
        this.ifCondition = (Operation)Assert.checkNotNullParam((String)"ifCondition", (Object)ifCondition);
        this.ifRequest = ctx.buildRequest((String)Assert.checkNotNullParam((String)"ifRequest", (Object)ifRequest));
        ctx.set(CommandContext.Scope.CONTEXT, CTX_KEY, this);
    }

    @Override
    public void set(CommandLineRedirection.Registration registration) {
        this.registration = registration;
    }

    @Override
    public void handle(CommandContext ctx) throws CommandLineException {
        ParsedCommandLine line = ctx.getParsedCommandLine();
        if (line.getFormat() == CommandFormat.INSTANCE) {
            if (line.hasProperty("--help") || line.hasProperty("-h")) {
                this.registration.handle(line);
                return;
            }
            String cmd = line.getOperationName();
            if ("if".equals(cmd)) {
                throw new CommandFormatException("if is not allowed while in if block");
            }
            if ("else".equals(cmd) || "end-if".equals(cmd)) {
                this.registration.handle(line);
            } else {
                this.addLine(line);
            }
        } else {
            this.addLine(line);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void run(CommandContext ctx) throws CommandLineException {
        try {
            ModelNode targetValue;
            ModelControllerClient client = ctx.getModelControllerClient();
            if (client == null) {
                throw new CommandLineException("The connection to the controller has not been established.");
            }
            try {
                targetValue = ctx.execute(this.ifRequest, "if condition");
            }
            catch (IOException e) {
                throw new CommandLineException("condition request failed", e);
            }
            Object value = this.ifCondition.resolveValue(ctx, targetValue);
            if (value == null) {
                throw new CommandLineException("if expression resolved to a null");
            }
            this.registration.unregister();
            if (Boolean.TRUE.equals(value)) {
                this.executeBlock(ctx, this.ifBlock, "if");
            } else if (this.inElse) {
                this.executeBlock(ctx, this.elseBlock, "else");
            }
        }
        finally {
            if (this.registration.isActive()) {
                this.registration.unregister();
            }
            ctx.remove(CommandContext.Scope.CONTEXT, CTX_KEY);
        }
    }

    boolean isInIf() {
        return !this.inElse;
    }

    void moveToElse() {
        this.inElse = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeBlock(CommandContext ctx, List<String> block, String blockName) throws CommandLineException {
        if (block != null && !block.isEmpty()) {
            BatchManager batchManager = ctx.getBatchManager();
            boolean discardActivatedBatch = !batchManager.isBatchActive();
            try {
                for (String l : block) {
                    ctx.handle(l);
                }
            }
            finally {
                if (discardActivatedBatch && batchManager.isBatchActive()) {
                    batchManager.discardActiveBatch();
                }
            }
        }
    }

    private void addLine(ParsedCommandLine line) {
        if (this.inElse) {
            if (this.elseBlock == null) {
                this.elseBlock = new ArrayList<String>();
            }
            this.elseBlock.add(line.getOriginalLine());
        } else {
            if (this.ifBlock == null) {
                this.ifBlock = new ArrayList<String>();
            }
            this.ifBlock.add(line.getOriginalLine());
        }
    }
}

