/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.datasources.agroal;

import java.lang.reflect.Method;
import java.sql.Driver;
import java.util.ServiceLoader;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLoadException;
import org.jboss.msc.Service;
import org.jboss.msc.service.ValueService;
import org.jboss.msc.value.Value;
import org.wildfly.extension.datasources.agroal.DriverDefinition;
import org.wildfly.extension.datasources.agroal.logging.AgroalLogger;

class DriverOperations {
    static final OperationStepHandler ADD_OPERATION = new DriverAdd();
    static final OperationStepHandler REMOVE_OPERATION = new DriverRemove();
    static final OperationStepHandler INFO_OPERATION = new DriverInfo();

    DriverOperations() {
    }

    private static class DriverInfo
    implements OperationStepHandler {
        private DriverInfo() {
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            if (context.isNormalServer()) {
                Class providerClass = (Class)context.getServiceRegistry(false).getService(DriverDefinition.AGROAL_DRIVER_CAPABILITY.getCapabilityServiceName(context.getCurrentAddress())).getValue();
                if (providerClass == null) {
                    context.getResult().set(new ModelNode());
                    return;
                }
                ModelNode result = new ModelNode();
                if (XADataSource.class.isAssignableFrom(providerClass) || DataSource.class.isAssignableFrom(providerClass)) {
                    for (Method method : providerClass.getMethods()) {
                        String name = method.getName();
                        if (method.getParameterCount() != 1 || !name.startsWith("set")) continue;
                        result.get(name.substring(3)).set(method.getParameterTypes()[0].getName());
                    }
                }
                context.getResult().set(result);
            }
        }
    }

    private static class DriverRemove
    extends AbstractRemoveStepHandler {
        private DriverRemove() {
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            context.removeService(DriverDefinition.AGROAL_DRIVER_CAPABILITY.getCapabilityServiceName(context.getCurrentAddress()));
            AgroalLogger.DRIVER_LOGGER.debugf("unloaded driver: %s", context.getCurrentAddressValue());
        }
    }

    private static class DriverAdd
    extends AbstractAddStepHandler {
        private DriverAdd() {
            super(DriverDefinition.ATTRIBUTES);
        }

        private static Class<?> loadClass(String driverName, String moduleName, String className) throws IllegalArgumentException {
            try {
                Module module = Module.getCallerModuleLoader().loadModule(moduleName);
                AgroalLogger.DRIVER_LOGGER.debugf("loaded module '%s' for driver: %s", moduleName, driverName);
                Class providerClass = module.getClassLoader().loadClass(className);
                AgroalLogger.DRIVER_LOGGER.driverLoaded(className, driverName);
                return providerClass;
            }
            catch (ModuleLoadException e) {
                throw AgroalLogger.DRIVER_LOGGER.loadModuleException(e, moduleName);
            }
            catch (ClassNotFoundException e) {
                throw AgroalLogger.DRIVER_LOGGER.loadClassException(e, className);
            }
        }

        private static Class<?> loadDriver(String driverName, String moduleName) throws IllegalArgumentException {
            try {
                Module module = Module.getCallerModuleLoader().loadModule(moduleName);
                AgroalLogger.DRIVER_LOGGER.debugf("loaded module '%s' for driver: %s", moduleName, driverName);
                ServiceLoader serviceLoader = module.loadService(Driver.class);
                if (serviceLoader.iterator().hasNext()) {
                    Class<?> driverClass = ((Driver)serviceLoader.iterator().next()).getClass();
                    AgroalLogger.DRIVER_LOGGER.driverLoaded(driverClass.getName(), driverName);
                    return driverClass;
                }
                return null;
            }
            catch (ModuleLoadException e) {
                throw AgroalLogger.DRIVER_LOGGER.loadModuleException(e, moduleName);
            }
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            final String driverName = context.getCurrentAddressValue();
            final String moduleName = DriverDefinition.MODULE_ATTRIBUTE.resolveModelAttribute(context, model).asString();
            boolean classDefined = DriverDefinition.CLASS_ATTRIBUTE.resolveModelAttribute(context, model).isDefined();
            final String className = classDefined ? DriverDefinition.CLASS_ATTRIBUTE.resolveModelAttribute(context, model).asString() : null;
            ValueService driverService = new ValueService(new Value<Class<?>>(){

                public Class<?> getValue() throws IllegalStateException, IllegalArgumentException {
                    if (className != null) {
                        return DriverAdd.loadClass(driverName, moduleName, className);
                    }
                    return DriverAdd.loadDriver(driverName, moduleName);
                }
            });
            context.getCapabilityServiceTarget().addCapability(DriverDefinition.AGROAL_DRIVER_CAPABILITY.fromBaseCapability(driverName)).setInstance((Service)driverService).install();
        }
    }
}

