/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream;

import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.ServiceLoader;
import org.infinispan.protostream.BaseMarshaller;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.protostream.config.Configuration;
import org.infinispan.protostream.impl.SerializationContextImpl;
import org.wildfly.clustering.marshalling.protostream.ClassLoaderMarshaller;
import org.wildfly.clustering.marshalling.protostream.DefaultSerializationContextInitializerProvider;
import org.wildfly.clustering.marshalling.protostream.LangSerializationContextInitializer;
import org.wildfly.security.manager.WildFlySecurityManager;

public class SerializationContextBuilder {
    private static final String PROTOSTREAM_BASE_PACKAGE_NAME = BaseMarshaller.class.getPackage().getName();
    private final SerializationContext context = new SerializationContextImpl(Configuration.builder().build());

    public SerializationContextBuilder(ClassLoaderMarshaller marshaller) {
        this.register(Collections.singleton(new LangSerializationContextInitializer(marshaller)));
        this.register(EnumSet.allOf(DefaultSerializationContextInitializerProvider.class));
    }

    public ImmutableSerializationContext build() {
        return this.context;
    }

    public SerializationContextBuilder register(SerializationContextInitializer initializer) {
        this.init(initializer);
        return this;
    }

    public SerializationContextBuilder register(SerializationContextInitializer ... initializers) {
        return this.register(Arrays.asList(initializers));
    }

    public SerializationContextBuilder register(Iterable<? extends SerializationContextInitializer> initializers) {
        for (SerializationContextInitializer serializationContextInitializer : initializers) {
            this.init(serializationContextInitializer);
        }
        return this;
    }

    public SerializationContextBuilder load(ClassLoader loader) {
        this.tryLoad(loader);
        return this;
    }

    public SerializationContextBuilder require(ClassLoader loader) {
        if (!this.tryLoad(loader)) {
            throw new NoSuchElementException();
        }
        return this;
    }

    private boolean tryLoad(final ClassLoader loader) {
        PrivilegedAction<Iterator<SerializationContextInitializer>> action = new PrivilegedAction<Iterator<SerializationContextInitializer>>(){

            @Override
            public Iterator<SerializationContextInitializer> run() {
                return ServiceLoader.load(SerializationContextInitializer.class, loader).iterator();
            }
        };
        Iterator initializers = (Iterator)WildFlySecurityManager.doUnchecked((PrivilegedAction)action);
        boolean init = initializers.hasNext();
        while (initializers.hasNext()) {
            SerializationContextInitializer initializer = (SerializationContextInitializer)initializers.next();
            if (initializer.getClass().getName().startsWith(PROTOSTREAM_BASE_PACKAGE_NAME)) continue;
            this.init(initializer);
        }
        return init;
    }

    private void init(SerializationContextInitializer initializer) {
        initializer.registerSchema(this.context);
        initializer.registerMarshallers(this.context);
    }
}

