/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.logging.Attribute;
import org.jboss.as.logging.CommonAttributes;
import org.jboss.as.logging.Element;
import org.jboss.as.logging.LoggingSubsystemParser_6_0;
import org.jboss.as.logging.handlers.SyslogHandlerResourceDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLExtendedStreamReader;

class LoggingSubsystemParser_7_0
extends LoggingSubsystemParser_6_0 {
    LoggingSubsystemParser_7_0() {
    }

    @Override
    void parseSyslogHandler(XMLExtendedStreamReader reader, PathAddress address, List<ModelNode> operations, Set<String> names) throws XMLStreamException {
        ModelNode operation = Util.createAddOperation();
        String name = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        int count = reader.getAttributeCount();
        block17: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block17;
                }
                case ENABLED: {
                    CommonAttributes.ENABLED.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block17;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        if (!names.add(name)) {
            throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, name);
        }
        LoggingSubsystemParser_7_0.addOperationAddress(operation, address, "syslog-handler", name);
        EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
        block18: while (reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (!encountered.add(element)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            switch (element) {
                case APP_NAME: {
                    SyslogHandlerResourceDefinition.APP_NAME.parseAndSetParameter(LoggingSubsystemParser_7_0.readValueAttribute(reader), operation, (XMLStreamReader)reader);
                    continue block18;
                }
                case FACILITY: {
                    SyslogHandlerResourceDefinition.FACILITY.parseAndSetParameter(LoggingSubsystemParser_7_0.readValueAttribute(reader), operation, (XMLStreamReader)reader);
                    continue block18;
                }
                case HOSTNAME: {
                    SyslogHandlerResourceDefinition.HOSTNAME.parseAndSetParameter(LoggingSubsystemParser_7_0.readValueAttribute(reader), operation, (XMLStreamReader)reader);
                    continue block18;
                }
                case LEVEL: {
                    CommonAttributes.LEVEL.parseAndSetParameter(LoggingSubsystemParser_7_0.readNameAttribute(reader), operation, (XMLStreamReader)reader);
                    continue block18;
                }
                case FORMATTER: {
                    EnumSet<Element> requiredFormatter = EnumSet.of(Element.SYSLOG_FORMATTER);
                    block19: while (reader.nextTag() != 2) {
                        switch (Element.forName(reader.getLocalName())) {
                            case SYSLOG_FORMATTER: {
                                requiredFormatter.remove((Object)Element.SYSLOG_FORMATTER);
                                operation.get(SyslogHandlerResourceDefinition.SYSLOG_FORMATTER.getName()).set(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)Attribute.SYSLOG_TYPE.getLocalName()));
                                continue block19;
                            }
                            case NAMED_FORMATTER: {
                                SyslogHandlerResourceDefinition.NAMED_FORMATTER.parseAndSetParameter(LoggingSubsystemParser_7_0.readNameAttribute(reader), operation, (XMLStreamReader)reader);
                                continue block19;
                            }
                        }
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    if (requiredFormatter.isEmpty()) continue block18;
                    throw ParseUtils.missingRequiredElement((XMLExtendedStreamReader)reader, requiredFormatter);
                }
                case PORT: {
                    SyslogHandlerResourceDefinition.PORT.parseAndSetParameter(LoggingSubsystemParser_7_0.readValueAttribute(reader), operation, (XMLStreamReader)reader);
                    continue block18;
                }
                case SERVER_ADDRESS: {
                    SyslogHandlerResourceDefinition.SERVER_ADDRESS.parseAndSetParameter(LoggingSubsystemParser_7_0.readValueAttribute(reader), operation, (XMLStreamReader)reader);
                    continue block18;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        operations.add(operation);
    }
}

