/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging;

import io.smallrye.reactive.converters.ReactiveTypeConverter;
import io.smallrye.reactive.converters.Registry;
import io.smallrye.reactive.messaging.AbstractMediator;
import io.smallrye.reactive.messaging.MediatorConfiguration;
import io.smallrye.reactive.messaging.i18n.ProviderExceptions;
import io.smallrye.reactive.messaging.i18n.ProviderMessages;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.eclipse.microprofile.reactive.streams.operators.PublisherBuilder;
import org.eclipse.microprofile.reactive.streams.operators.ReactiveStreams;
import org.reactivestreams.Publisher;

public class StreamTransformerMediator
extends AbstractMediator {
    Function<PublisherBuilder<? extends Message<?>>, PublisherBuilder<? extends Message<?>>> function;
    private PublisherBuilder<? extends Message<?>> publisher;

    public StreamTransformerMediator(MediatorConfiguration configuration) {
        super(configuration);
        if (configuration.consumption() == MediatorConfiguration.Consumption.STREAM_OF_MESSAGE && configuration.production() == MediatorConfiguration.Production.STREAM_OF_PAYLOAD) {
            throw ProviderExceptions.ex.definitionProducePayloadStreamAndConsumeMessageStream(configuration.methodAsString());
        }
        if (configuration.consumption() == MediatorConfiguration.Consumption.STREAM_OF_PAYLOAD && configuration.production() == MediatorConfiguration.Production.STREAM_OF_MESSAGE) {
            throw ProviderExceptions.ex.definitionProduceMessageStreamAndConsumePayloadStream(configuration.methodAsString());
        }
    }

    @Override
    public void connectToUpstream(PublisherBuilder<? extends Message<?>> publisher) {
        Objects.requireNonNull(this.function);
        this.publisher = this.decorate(this.function.apply(this.convert(publisher)));
    }

    @Override
    public PublisherBuilder<? extends Message<?>> getStream() {
        Objects.requireNonNull(this.publisher);
        return this.publisher;
    }

    @Override
    public boolean isConnected() {
        return this.publisher != null;
    }

    @Override
    public void initialize(Object bean) {
        super.initialize(bean);
        switch (this.configuration.consumption()) {
            case STREAM_OF_MESSAGE: {
                if (this.configuration.usesBuilderTypes()) {
                    this.processMethodConsumingAPublisherBuilderOfMessages();
                    break;
                }
                this.processMethodConsumingAPublisherOfMessages();
                break;
            }
            case STREAM_OF_PAYLOAD: {
                if (this.configuration.usesBuilderTypes()) {
                    this.processMethodConsumingAPublisherBuilderOfPayload();
                    break;
                }
                this.processMethodConsumingAPublisherOfPayload();
                break;
            }
            default: {
                throw ProviderExceptions.ex.illegalArgumentForUnexpectedConsumption(this.configuration.consumption());
            }
        }
        assert (this.function != null);
    }

    private void processMethodConsumingAPublisherBuilderOfMessages() {
        this.function = publisher -> {
            PublisherBuilder prependedWithAck = publisher.flatMapCompletionStage(this.managePreProcessingAck());
            PublisherBuilder builder = (PublisherBuilder)this.invoke(prependedWithAck);
            Objects.requireNonNull(builder, ProviderMessages.msg.methodReturnedNull(this.configuration.methodAsString()));
            return builder;
        };
    }

    private void processMethodConsumingAPublisherOfMessages() {
        this.function = publisher -> {
            Publisher prependedWithAck = publisher.flatMapCompletionStage(this.managePreProcessingAck()).buildRs();
            Class parameterType = this.configuration.getParameterTypes()[0];
            Optional converter = Registry.lookup((Class)parameterType);
            if (converter.isPresent()) {
                prependedWithAck = (Publisher)((ReactiveTypeConverter)converter.get()).fromPublisher(prependedWithAck);
            }
            Publisher result = (Publisher)this.invoke(prependedWithAck);
            Objects.requireNonNull(result, ProviderMessages.msg.methodReturnedNull(this.configuration.methodAsString()));
            return ReactiveStreams.fromPublisher((Publisher)result);
        };
    }

    private void processMethodConsumingAPublisherBuilderOfPayload() {
        this.function = builder -> {
            PublisherBuilder unwrapped = builder.flatMapCompletionStage(this.managePreProcessingAck()).map(Message::getPayload);
            PublisherBuilder result = (PublisherBuilder)this.invoke(unwrapped);
            Objects.requireNonNull(result, ProviderMessages.msg.methodReturnedNull(this.configuration.methodAsString()));
            return result.map(o -> Message.of((Object)o));
        };
    }

    private void processMethodConsumingAPublisherOfPayload() {
        this.function = builder -> {
            Publisher stream = builder.flatMapCompletionStage(this.managePreProcessingAck()).map(Message::getPayload).buildRs();
            Class parameterType = this.configuration.getParameterTypes()[0];
            Optional converter = Registry.lookup((Class)parameterType);
            if (converter.isPresent()) {
                stream = (Publisher)((ReactiveTypeConverter)converter.get()).fromPublisher(stream);
            }
            Publisher result = (Publisher)this.invoke(stream);
            Objects.requireNonNull(result, ProviderMessages.msg.methodReturnedNull(this.configuration.methodAsString()));
            return ReactiveStreams.fromPublisher((Publisher)result).map(o -> Message.of((Object)o));
        };
    }
}

