/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import org.infinispan.commons.configuration.ConfigurationInfo;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.attributes.Matchable;
import org.infinispan.commons.configuration.elements.DefaultElementDefinition;
import org.infinispan.commons.configuration.elements.ElementDefinition;
import org.infinispan.commons.util.ByteQuantity;
import org.infinispan.configuration.cache.MemoryStorageConfiguration;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.configuration.parsing.Element;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.eviction.EvictionType;
import org.infinispan.util.logging.Log;

public class MemoryConfiguration
implements Matchable<MemoryConfiguration>,
ConfigurationInfo {
    public static final ElementDefinition<?> ELEMENT_DEFINITION = new DefaultElementDefinition(Element.MEMORY.getLocalName());
    public static final AttributeDefinition<StorageType> STORAGE = AttributeDefinition.builder((String)"storage", (Object)((Object)StorageType.HEAP)).immutable().build();
    public static final AttributeDefinition<String> MAX_SIZE = AttributeDefinition.builder((String)"maxSize", null, String.class).build();
    public static final AttributeDefinition<Long> MAX_COUNT = AttributeDefinition.builder((String)"maxCount", (Object)-1L).build();
    public static final AttributeDefinition<EvictionStrategy> WHEN_FULL = AttributeDefinition.builder((String)"whenFull", (Object)((Object)EvictionStrategy.NONE)).immutable().build();
    private final MemoryStorageConfiguration memoryStorageConfiguration;
    private final AttributeSet attributes;

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(MemoryConfiguration.class, new AttributeDefinition[]{STORAGE, MAX_SIZE, MAX_COUNT, WHEN_FULL});
    }

    MemoryConfiguration(AttributeSet attributes, MemoryStorageConfiguration memoryStorageConfiguration) {
        this.memoryStorageConfiguration = memoryStorageConfiguration;
        this.attributes = attributes.checkProtection();
        memoryStorageConfiguration.attributes().attribute(MemoryStorageConfiguration.SIZE).addListener((a, oldValue) -> this.updateSize((Long)a.get()));
    }

    public ElementDefinition<?> getElementDefinition() {
        return ELEMENT_DEFINITION;
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public boolean isOffHeap() {
        return this.attributes.attribute(STORAGE).get() == StorageType.OFF_HEAP;
    }

    public long maxSizeBytes() {
        return MemoryConfiguration.maxSizeToBytes(this.maxSize());
    }

    public String maxSize() {
        return (String)this.attributes.attribute(MAX_SIZE).get();
    }

    public void maxSize(String maxSize) {
        if (!this.isSizeBounded()) {
            throw Log.CONFIG.cannotChangeMaxSize();
        }
        this.attributes.attribute(MAX_SIZE).set((Object)maxSize);
        this.memoryStorageConfiguration.attributes().attribute(MemoryStorageConfiguration.SIZE).set((Object)MemoryConfiguration.maxSizeToBytes(maxSize));
    }

    public long maxCount() {
        return (Long)this.attributes.attribute(MAX_COUNT).get();
    }

    public void maxCount(long maxCount) {
        if (!this.isCountBounded()) {
            throw Log.CONFIG.cannotChangeMaxCount();
        }
        this.attributes.attribute(MAX_COUNT).set((Object)maxCount);
        this.memoryStorageConfiguration.attributes().attribute(MemoryStorageConfiguration.SIZE).set((Object)maxCount);
    }

    @Deprecated
    public StorageType storageType() {
        return this.storage();
    }

    public StorageType storage() {
        return (StorageType)((Object)this.attributes.attribute(STORAGE).get());
    }

    @Deprecated
    public long size() {
        return this.memoryStorageConfiguration.size();
    }

    @Deprecated
    public void size(long newSize) {
        this.memoryStorageConfiguration.size(newSize);
    }

    private void updateSize(long newSize) {
        if (this.isCountBounded()) {
            this.attributes.attribute(MAX_COUNT).set((Object)newSize);
        } else {
            this.attributes.attribute(MAX_SIZE).set((Object)String.valueOf(newSize));
        }
    }

    @Deprecated
    public EvictionType evictionType() {
        return this.memoryStorageConfiguration.evictionType();
    }

    @Deprecated
    public EvictionStrategy evictionStrategy() {
        return this.memoryStorageConfiguration.evictionStrategy();
    }

    public EvictionStrategy whenFull() {
        return (EvictionStrategy)((Object)this.attributes.attribute(WHEN_FULL).get());
    }

    public boolean isEvictionEnabled() {
        return (this.isSizeBounded() || this.isCountBounded()) && this.whenFull().isRemovalBased();
    }

    private boolean isSizeBounded() {
        return this.maxSize() != null;
    }

    private boolean isCountBounded() {
        return this.maxCount() > 0L;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MemoryConfiguration that = (MemoryConfiguration)o;
        if (!this.memoryStorageConfiguration.equals(that.memoryStorageConfiguration)) {
            return false;
        }
        return this.attributes.equals((Object)that.attributes);
    }

    public int hashCode() {
        int result = this.memoryStorageConfiguration.hashCode();
        result = 31 * result + this.attributes.hashCode();
        return result;
    }

    public String toString() {
        return "MemoryConfiguration{memoryStorageConfiguration=" + this.memoryStorageConfiguration + ", attributes=" + this.attributes + '}';
    }

    @Deprecated
    public MemoryStorageConfiguration heapConfiguration() {
        return this.memoryStorageConfiguration;
    }

    static long maxSizeToBytes(String maxSizeStr) {
        return maxSizeStr != null ? ByteQuantity.parse((String)maxSizeStr) : -1L;
    }
}

