/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.kafka.impl;

import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.Subscriptions;
import io.smallrye.mutiny.operators.AbstractMulti;
import io.smallrye.mutiny.subscription.MultiSubscriber;
import io.smallrye.reactive.messaging.kafka.KafkaConnectorIncomingConfiguration;
import io.smallrye.reactive.messaging.kafka.i18n.KafkaLogging;
import io.smallrye.reactive.messaging.kafka.impl.ReactiveKafkaConsumer;
import io.smallrye.reactive.messaging.kafka.impl.RecordQueue;
import io.vertx.core.Context;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.reactivestreams.Subscription;

public class KafkaRecordStream<K, V>
extends AbstractMulti<ConsumerRecord<K, V>> {
    private static final int STATE_NEW = 0;
    private static final int STATE_POLLING = 1;
    private static final int STATE_PAUSED = 2;
    private static final int STATE_CANCELLED = 3;
    private final ReactiveKafkaConsumer<K, V> client;
    private final KafkaConnectorIncomingConfiguration config;
    private final Context context;

    public KafkaRecordStream(ReactiveKafkaConsumer<K, V> client, KafkaConnectorIncomingConfiguration config, Context context) {
        this.config = config;
        this.client = client;
        this.context = context;
    }

    public void subscribe(MultiSubscriber<? super ConsumerRecord<K, V>> subscriber) {
        KafkaRecordStreamSubscription subscription = new KafkaRecordStreamSubscription(this.client, this.config, subscriber);
        subscriber.onSubscribe((Subscription)subscription);
    }

    private class KafkaRecordStreamSubscription
    implements Subscription {
        private final ReactiveKafkaConsumer<K, V> client;
        private final MultiSubscriber<? super ConsumerRecord<K, V>> downstream;
        private final boolean pauseResumeEnabled;
        private final AtomicInteger state = new AtomicInteger(0);
        private final AtomicInteger wip = new AtomicInteger();
        private final AtomicLong requested = new AtomicLong();
        private final Uni<ConsumerRecords<K, V>> pollUni;
        private final int maxQueueSize;
        private final int halfMaxQueueSize;
        private final RecordQueue<ConsumerRecord<K, V>> queue;
        private final long retries;

        public KafkaRecordStreamSubscription(ReactiveKafkaConsumer<K, V> client, KafkaConnectorIncomingConfiguration config, MultiSubscriber<? super ConsumerRecord<K, V>> subscriber) {
            this.client = client;
            this.pauseResumeEnabled = config.getPauseIfNoRequests();
            this.downstream = subscriber;
            int batchSize = config.config().getOptionalValue("max.poll.records", Integer.class).orElse(500);
            this.maxQueueSize = batchSize * 2;
            this.halfMaxQueueSize = batchSize;
            this.queue = new RecordQueue(3 * batchSize);
            this.retries = config.getRetryAttempts() == -1 ? Long.MAX_VALUE : (long)config.getRetryAttempts().intValue();
            this.pollUni = client.poll().onItem().transform(cr -> {
                if (cr.isEmpty()) {
                    return null;
                }
                if (KafkaLogging.log.isTraceEnabled()) {
                    KafkaLogging.log.tracef("Adding %s messages to the queue", cr.count());
                }
                this.queue.addAll((Iterable)cr);
                return cr;
            }).plug(m -> {
                if (config.getRetry().booleanValue()) {
                    int maxWait = config.getRetryMaxWait();
                    return m.onFailure().retry().withBackOff(Duration.ofSeconds(1L), Duration.ofSeconds(maxWait)).atMost(this.retries);
                }
                return m;
            });
        }

        public void request(long n) {
            if (n > 0L) {
                boolean cancelled;
                boolean bl = cancelled = this.state.get() == 3;
                if (!cancelled) {
                    Subscriptions.add((AtomicLong)this.requested, (long)n);
                    if (this.state.compareAndSet(0, 1)) {
                        this.poll();
                    } else {
                        this.dispatch();
                    }
                }
            } else {
                throw new IllegalArgumentException("Invalid request");
            }
        }

        private void poll() {
            int state = this.state.get();
            if (state == 3 || state == 0 || this.client.isClosed()) {
                return;
            }
            if (this.pauseResumeEnabled) {
                this.pauseResume();
            }
            this.pollUni.subscribe().with(cr -> {
                if (cr == null) {
                    this.client.executeWithDelay(this::poll, Duration.ofMillis(2L)).subscribe().with(this::emptyConsumer, this::report);
                } else {
                    this.dispatch();
                    this.client.runOnPollingThread(c -> this.poll()).subscribe().with(this::emptyConsumer, this::report);
                }
            }, this::report);
        }

        private void pauseResume() {
            int size = this.queue.size();
            if (size >= this.maxQueueSize && this.state.compareAndSet(1, 2)) {
                KafkaLogging.log.pausingChannel(KafkaRecordStream.this.config.getChannel(), size, this.maxQueueSize);
                this.client.pause().subscribe().with(this::emptyConsumer, this::report);
            } else if (size <= this.halfMaxQueueSize && this.state.compareAndSet(2, 1)) {
                KafkaLogging.log.resumingChannel(KafkaRecordStream.this.config.getChannel(), size, this.halfMaxQueueSize);
                this.client.resume().subscribe().with(this::emptyConsumer, this::report);
            }
        }

        private <T> void emptyConsumer(T ignored) {
        }

        private void report(Throwable fail) {
            int state;
            while ((state = this.state.get()) != 3) {
                if (!this.state.compareAndSet(state, 3)) continue;
                this.downstream.onFailure(fail);
                break;
            }
        }

        void dispatch() {
            if (this.wip.getAndIncrement() != 0) {
                return;
            }
            KafkaRecordStream.this.context.runOnContext(ignored -> this.run());
        }

        private void run() {
            int missed = 1;
            RecordQueue q = this.queue;
            long emitted = 0L;
            long requests = this.requested.get();
            while (true) {
                ConsumerRecord item;
                if (this.isCancelled()) {
                    return;
                }
                while (emitted != requests && (item = q.poll()) != null && !this.isCancelled()) {
                    this.downstream.onItem(item);
                    ++emitted;
                }
                requests = this.requested.addAndGet(-emitted);
                emitted = 0L;
                int w = this.wip.get();
                if (missed == w) {
                    if ((missed = this.wip.addAndGet(-missed)) != 0) continue;
                    break;
                }
                missed = w;
            }
        }

        public void cancel() {
            int state;
            while ((state = this.state.get()) != 3) {
                if (!this.state.compareAndSet(state, 3)) continue;
                if (this.wip.getAndIncrement() != 0) break;
                this.client.close();
                this.queue.clear();
                break;
            }
        }

        boolean isCancelled() {
            if (this.state.get() == 3) {
                this.queue.clear();
                this.client.close();
                return true;
            }
            return false;
        }
    }
}

