/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron.oidc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.web.common.WarMetaData;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.wildfly.extension.elytron.oidc.CredentialDefinition;
import org.wildfly.extension.elytron.oidc.SecureDeploymentDefinition;
import org.wildfly.extension.elytron.oidc._private.ElytronOidcLogger;

public final class OidcConfigService {
    private static final String CREDENTIALS_JSON_NAME = "credentials";
    private static final String REDIRECT_REWRITE_RULE_JSON_NAME = "redirect-rewrite-rules";
    private static final OidcConfigService INSTANCE = new OidcConfigService();
    private final Map<String, ModelNode> realms = new HashMap<String, ModelNode>();
    private final Map<String, ModelNode> providers = new HashMap<String, ModelNode>();
    private final Map<String, ModelNode> secureDeployments = new HashMap<String, ModelNode>();

    public static OidcConfigService getInstance() {
        return INSTANCE;
    }

    private OidcConfigService() {
    }

    public void addRealm(ModelNode operation, ModelNode model) {
        this.realms.put(this.realmNameFromOp(operation), model.clone());
    }

    public void updateRealm(ModelNode operation, String attrName, ModelNode resolvedValue) {
        ModelNode realm = this.realms.get(this.realmNameFromOp(operation));
        realm.get(attrName).set(resolvedValue);
    }

    public void removeRealm(ModelNode operation) {
        this.realms.remove(this.realmNameFromOp(operation));
    }

    public void addProvider(ModelNode operation, ModelNode model) {
        this.providers.put(this.providerNameFromOp(operation), model.clone());
    }

    public void updateProvider(ModelNode operation, String attrName, ModelNode resolvedValue) {
        ModelNode realm = this.providers.get(this.providerNameFromOp(operation));
        realm.get(attrName).set(resolvedValue);
    }

    public void removeProvider(ModelNode operation) {
        this.providers.remove(this.providerNameFromOp(operation));
    }

    public void addSecureDeployment(ModelNode operation, ModelNode model) {
        ModelNode deployment = model.clone();
        String name = this.deploymentNameFromOp(operation);
        this.secureDeployments.put(name, deployment);
    }

    public void updateSecureDeployment(ModelNode operation, String attrName, ModelNode resolvedValue) {
        ModelNode deployment = this.secureDeployments.get(this.deploymentNameFromOp(operation));
        deployment.get(attrName).set(resolvedValue);
    }

    public void removeSecureDeployment(ModelNode operation) {
        String name = this.deploymentNameFromOp(operation);
        this.secureDeployments.remove(name);
    }

    public void addCredential(ModelNode operation, ModelNode model) {
        ModelNode credentials = this.credentialsFromOp(operation);
        if (!credentials.isDefined()) {
            credentials = new ModelNode();
        }
        this.setCredential(operation, model, credentials);
        ModelNode deployment = this.secureDeployments.get(this.deploymentNameFromOp(operation));
        deployment.get(CREDENTIALS_JSON_NAME).set(credentials);
    }

    private void setCredential(ModelNode operation, ModelNode model, ModelNode credentials) {
        String credentialName = this.credentialNameFromOp(operation);
        if (credentialName.equals("secret")) {
            credentials.get(credentialName).set(model.get("secret").asString());
        } else {
            credentials.set(credentialName, this.getCredentialValue(model));
        }
    }

    private ModelNode getCredentialValue(ModelNode model) {
        ModelNode credential = new ModelNode();
        for (SimpleAttributeDefinition attribute : CredentialDefinition.ATTRIBUTES) {
            String attributeName = attribute.getName();
            ModelNode attributeValue = model.get(attributeName);
            if (!attributeValue.isDefined()) continue;
            credential.get(attributeName).set(attributeValue.asString());
        }
        return credential;
    }

    public void removeCredential(ModelNode operation) {
        ModelNode credentials = this.credentialsFromOp(operation);
        if (!credentials.isDefined()) {
            throw ElytronOidcLogger.ROOT_LOGGER.cannotRemoveCredential(operation.toString());
        }
        String credentialName = this.credentialNameFromOp(operation);
        credentials.remove(credentialName);
    }

    public void updateCredential(ModelNode operation, String attrName, ModelNode resolvedValue) {
        ModelNode credentials = this.credentialsFromOp(operation);
        if (!credentials.isDefined()) {
            throw ElytronOidcLogger.ROOT_LOGGER.cannotUpdateCredential(operation.toString());
        }
        this.setCredential(operation, resolvedValue, credentials);
    }

    private ModelNode credentialsFromOp(ModelNode operation) {
        ModelNode deployment = this.secureDeployments.get(this.deploymentNameFromOp(operation));
        return deployment.get(CREDENTIALS_JSON_NAME);
    }

    public void addRedirectRewriteRule(ModelNode operation, ModelNode model) {
        ModelNode redirectRewritesRules = this.redirectRewriteRuleFromOp(operation);
        if (!redirectRewritesRules.isDefined()) {
            redirectRewritesRules = new ModelNode();
        }
        String redirectRewriteRuleName = this.redirectRewriteRule(operation);
        redirectRewritesRules.get(redirectRewriteRuleName).set(model.get("replacement").asString());
        ModelNode deployment = this.secureDeployments.get(this.deploymentNameFromOp(operation));
        deployment.get(REDIRECT_REWRITE_RULE_JSON_NAME).set(redirectRewritesRules);
    }

    public void removeRedirectRewriteRule(ModelNode operation) {
        ModelNode redirectRewritesRules = this.redirectRewriteRuleFromOp(operation);
        if (!redirectRewritesRules.isDefined()) {
            throw ElytronOidcLogger.ROOT_LOGGER.cannotRemoveRedirectRuntimeRule(operation.toString());
        }
        String ruleName = this.credentialNameFromOp(operation);
        redirectRewritesRules.remove(ruleName);
    }

    public void updateRedirectRewriteRule(ModelNode operation, String attrName, ModelNode resolvedValue) {
        ModelNode redirectRewritesRules = this.redirectRewriteRuleFromOp(operation);
        if (!redirectRewritesRules.isDefined()) {
            throw ElytronOidcLogger.ROOT_LOGGER.cannotUpdateRedirectRuntimeRule(operation.toString());
        }
        String ruleName = this.credentialNameFromOp(operation);
        redirectRewritesRules.get(ruleName).set(resolvedValue.get("replacement").asString());
    }

    private ModelNode redirectRewriteRuleFromOp(ModelNode operation) {
        ModelNode deployment = this.secureDeployments.get(this.deploymentNameFromOp(operation));
        return deployment.get(REDIRECT_REWRITE_RULE_JSON_NAME);
    }

    private String providerNameFromOp(ModelNode operation) {
        return this.valueFromOpAddress("provider", operation);
    }

    private String realmNameFromOp(ModelNode operation) {
        return this.valueFromOpAddress("realm", operation);
    }

    private String deploymentNameFromOp(ModelNode operation) {
        String deploymentName = this.valueFromOpAddress("secure-deployment", operation);
        if (deploymentName == null) {
            throw new RuntimeException("Can't find deployment name in address " + operation);
        }
        return deploymentName;
    }

    private String credentialNameFromOp(ModelNode operation) {
        return this.valueFromOpAddress("credential", operation);
    }

    private String redirectRewriteRule(ModelNode operation) {
        return this.valueFromOpAddress("redirect-rewrite-rule", operation);
    }

    private String valueFromOpAddress(String addrElement, ModelNode operation) {
        return this.getValueOfAddrElement(operation.get("address"), addrElement);
    }

    private String getValueOfAddrElement(ModelNode address, String elementName) {
        for (ModelNode element : address.asList()) {
            if (!element.has(elementName)) continue;
            return element.get(elementName).asString();
        }
        return null;
    }

    protected boolean isDeploymentConfigured(DeploymentUnit deploymentUnit) {
        ModelNode deployment = this.getSecureDeployment(deploymentUnit);
        if (!deployment.isDefined()) {
            return false;
        }
        ModelNode resource = deployment.get(SecureDeploymentDefinition.RESOURCE.getName());
        ModelNode clientId = deployment.get(SecureDeploymentDefinition.CLIENT_ID.getName());
        return resource.isDefined() || clientId.isDefined();
    }

    public String getJSON(DeploymentUnit deploymentUnit) {
        ModelNode deployment = this.getSecureDeployment(deploymentUnit);
        return this.getJSON(deployment);
    }

    public String getJSON(String deploymentName) {
        ModelNode deployment = this.secureDeployments.get(deploymentName);
        return this.getJSON(deployment);
    }

    private String getJSON(ModelNode deployment) {
        ModelNode json = new ModelNode();
        ModelNode realmOrProvider = null;
        String realmName = deployment.get("realm").asStringOrNull();
        if (realmName != null) {
            realmOrProvider = this.realms.get(realmName);
            json.get("realm").set(realmName);
        } else {
            String providerName = deployment.get("provider").asStringOrNull();
            if (providerName != null) {
                realmOrProvider = this.providers.get(providerName);
                deployment.remove("provider");
            }
        }
        if (realmOrProvider != null) {
            this.setJSONValues(json, realmOrProvider);
        }
        this.setJSONValues(json, deployment);
        return json.toJSONString(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setJSONValues(ModelNode json, ModelNode values) {
        ModelNode modelNode = values;
        synchronized (modelNode) {
            for (Property prop : new ArrayList(values.asPropertyList())) {
                String name = prop.getName();
                ModelNode value = prop.getValue();
                if (!value.isDefined()) continue;
                json.get(name).set(value);
            }
        }
    }

    public boolean isSecureDeployment(DeploymentUnit deploymentUnit) {
        String deploymentName = this.preferredDeploymentName(deploymentUnit);
        return this.secureDeployments.containsKey(deploymentName);
    }

    private ModelNode getSecureDeployment(DeploymentUnit deploymentUnit) {
        String deploymentName = this.preferredDeploymentName(deploymentUnit);
        return this.secureDeployments.containsKey(deploymentName) ? this.secureDeployments.get(deploymentName) : new ModelNode();
    }

    private String preferredDeploymentName(DeploymentUnit deploymentUnit) {
        String deploymentName = deploymentUnit.getName();
        WarMetaData warMetaData = (WarMetaData)deploymentUnit.getAttachment(WarMetaData.ATTACHMENT_KEY);
        if (warMetaData == null) {
            return deploymentName;
        }
        JBossWebMetaData webMetaData = warMetaData.getMergedJBossWebMetaData();
        if (webMetaData == null) {
            return deploymentName;
        }
        String moduleName = webMetaData.getModuleName();
        if (moduleName != null) {
            return moduleName + ".war";
        }
        return deploymentName;
    }
}

