/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.agent.unix;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.sshd.agent.SshAgentServer;
import org.apache.sshd.agent.unix.AgentForwardedChannel;
import org.apache.sshd.agent.unix.AprLibrary;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.session.ConnectionService;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.OsUtils;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;
import org.apache.sshd.common.util.threads.CloseableExecutorService;
import org.apache.sshd.common.util.threads.ThreadUtils;
import org.apache.sshd.core.CoreModuleProperties;
import org.apache.tomcat.jni.Error;
import org.apache.tomcat.jni.Local;
import org.apache.tomcat.jni.Pool;
import org.apache.tomcat.jni.Socket;

public class AgentServerProxy
extends AbstractLoggingBean
implements SshAgentServer {
    private static final byte[] END_OF_STREAM_MESSAGE = new byte[]{"END_OF_STREAM".getBytes(StandardCharsets.UTF_8)[0]};
    private final ConnectionService service;
    private final String authSocket;
    private final long pool;
    private final long handle;
    private Future<?> piper;
    private final CloseableExecutorService pipeService;
    private final AtomicBoolean open = new AtomicBoolean(true);
    private final AtomicBoolean innerFinished = new AtomicBoolean(false);

    public AgentServerProxy(ConnectionService service) throws IOException {
        this(service, null);
    }

    public AgentServerProxy(ConnectionService service, CloseableExecutorService executor) throws IOException {
        this.service = service;
        try {
            String authSocket = AprLibrary.createLocalSocketAddress();
            this.pool = Pool.create((long)AprLibrary.getInstance().getRootPool());
            this.handle = Local.create((String)authSocket, (long)this.pool);
            this.authSocket = authSocket;
            int result = Local.bind((long)this.handle, (long)0L);
            if (result != 0) {
                throw AgentServerProxy.toIOException(result);
            }
            AprLibrary.secureLocalSocket(authSocket, this.handle);
            result = Local.listen((long)this.handle, (int)0);
            if (result != 0) {
                throw AgentServerProxy.toIOException(result);
            }
            this.pipeService = executor == null ? ThreadUtils.newSingleThreadExecutor((String)("sshd-AgentServerProxy-PIPE-" + authSocket)) : ThreadUtils.noClose((CloseableExecutorService)executor);
            this.piper = this.pipeService.submit(() -> {
                try {
                    while (this.isOpen()) {
                        try {
                            long clientSock = Local.accept((long)this.handle);
                            if (!this.isOpen()) {
                                break;
                            }
                            Object session = this.service.getSession();
                            Socket.timeoutSet((long)clientSock, (long)(((Duration)CoreModuleProperties.AUTH_SOCKET_TIMEOUT.getRequired(session)).toMillis() * 1000L));
                            String channelType = (String)CoreModuleProperties.PROXY_CHANNEL_TYPE.getRequired(session);
                            AgentForwardedChannel channel = new AgentForwardedChannel(clientSock, channelType);
                            this.service.registerChannel(channel);
                            channel.open().verify((Duration)CoreModuleProperties.CHANNEL_OPEN_TIMEOUT.getRequired(session));
                        }
                        catch (Exception e) {
                            this.debug("run(open={}) {} while authentication forwarding: {}", this.isOpen(), e.getClass().getSimpleName(), e.getMessage(), e);
                        }
                    }
                }
                finally {
                    this.innerFinished.set(true);
                }
            });
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SshException((Throwable)e);
        }
    }

    @Override
    public boolean isOpen() {
        return this.open.get();
    }

    public CloseableExecutorService getExecutorService() {
        return this.pipeService;
    }

    @Override
    public String getId() {
        return this.authSocket;
    }

    @Override
    public synchronized void close() throws IOException {
        boolean debugEnabled;
        block16: {
            if (!this.open.getAndSet(false)) {
                return;
            }
            debugEnabled = this.log.isDebugEnabled();
            if (this.handle != 0L) {
                int closeCode;
                block15: {
                    if (!this.innerFinished.get()) {
                        try {
                            this.signalEOS(AprLibrary.getInstance(), debugEnabled);
                        }
                        catch (Exception e) {
                            if (!debugEnabled) break block15;
                            this.log.debug("Exception signalling EOS to the PIPE socket: " + this.authSocket, (Throwable)e);
                        }
                    }
                }
                if ((closeCode = Socket.close((long)this.handle)) != 0) {
                    this.log.warn("Exceptions closing the PIPE: {}. APR error code: {} ", (Object)this.authSocket, (Object)closeCode);
                }
            }
            try {
                if (this.authSocket != null) {
                    this.removeSocketFile(this.authSocket, debugEnabled);
                }
            }
            catch (Exception e) {
                if (!debugEnabled) break block16;
                this.log.debug("Exception deleting the PIPE socket: " + this.authSocket, (Throwable)e);
            }
        }
        try {
            if (this.piper != null && !this.piper.isDone()) {
                this.piper.cancel(true);
            }
        }
        finally {
            this.piper = null;
        }
        CloseableExecutorService executor = this.getExecutorService();
        if (executor != null && !executor.isShutdown()) {
            List runners = executor.shutdownNow();
            if (debugEnabled) {
                this.log.debug("Shut down runners count=" + GenericUtils.size((Collection)runners));
            }
        }
    }

    protected File removeSocketFile(String socketPath, boolean debugEnabled) throws Exception {
        File socketFile = new File(socketPath);
        if (socketFile.exists()) {
            this.deleteFile(socketFile, "Deleted PIPE socket {}", debugEnabled);
            if (OsUtils.isUNIX()) {
                this.deleteFile(socketFile.getParentFile(), "Deleted parent PIPE socket {}", debugEnabled);
            }
        }
        return socketFile;
    }

    protected void signalEOS(AprLibrary libInstance, boolean debugEnabled) throws Exception {
        int sendResult;
        long tmpPool = Pool.create((long)libInstance.getRootPool());
        long tmpSocket = Local.create((String)this.authSocket, (long)tmpPool);
        long connectResult = Local.connect((long)tmpSocket, (long)0L);
        if (connectResult != 0L && debugEnabled) {
            this.log.debug("Unable to connect to socket PIPE {}. APR errcode {}", (Object)this.authSocket, (Object)connectResult);
        }
        if ((sendResult = Socket.send((long)tmpSocket, (byte[])END_OF_STREAM_MESSAGE, (int)0, (int)1)) != 1 && debugEnabled) {
            this.log.debug("Unable to send signal the EOS for {}. APR retcode {} != 1", (Object)this.authSocket, (Object)sendResult);
        }
    }

    protected boolean deleteFile(File file, String msg, boolean debugEnabled) {
        boolean success = file.delete();
        if (success && debugEnabled) {
            this.log.debug(msg, (Object)file);
        }
        return success;
    }

    public static IOException toIOException(int code) {
        return new IOException(Error.strerror((int)(-code)) + " (code: " + code + ")");
    }
}

