/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.helpers.Subscriptions;
import io.smallrye.mutiny.operators.multi.AbstractMultiOperator;
import io.smallrye.mutiny.operators.multi.MultiOperatorProcessor;
import io.smallrye.mutiny.subscription.MultiSubscriber;
import org.reactivestreams.Subscription;

public final class MultiLastItemOp<T>
extends AbstractMultiOperator<T, T> {
    public MultiLastItemOp(Multi<T> upstream) {
        super(upstream);
    }

    @Override
    public void subscribe(MultiSubscriber<? super T> downstream) {
        this.upstream.subscribe().withSubscriber(new MultiLastItemProcessor<T>(downstream));
    }

    static final class MultiLastItemProcessor<T>
    extends MultiOperatorProcessor<T, T> {
        T last;

        MultiLastItemProcessor(MultiSubscriber<? super T> downstream) {
            super(downstream);
        }

        @Override
        public void onSubscribe(Subscription subscription) {
            if (this.upstream.compareAndSet(null, subscription)) {
                this.downstream.onSubscribe(this);
                subscription.request(Long.MAX_VALUE);
            } else {
                subscription.cancel();
            }
        }

        @Override
        public void request(long numberOfItems) {
        }

        @Override
        public void onItem(T item) {
            this.last = item;
        }

        @Override
        public void onFailure(Throwable failure) {
            super.onFailure(failure);
            this.last = null;
        }

        @Override
        public void onCompletion() {
            Subscription subscription = this.upstream.getAndSet(Subscriptions.CANCELLED);
            if (subscription != Subscriptions.CANCELLED) {
                T item = this.last;
                MultiSubscriber subscriber = this.downstream;
                if (item != null) {
                    this.last = null;
                    subscriber.onItem(item);
                }
                subscriber.onCompletion();
            }
        }
    }
}

