/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi;

import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.helpers.Subscriptions;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.subscription.MultiSubscriber;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscription;

public abstract class MultiOperatorProcessor<I, O>
implements MultiSubscriber<I>,
Subscription {
    protected volatile MultiSubscriber<? super O> downstream;
    protected AtomicReference<Subscription> upstream = new AtomicReference();
    AtomicBoolean hasDownstreamCancelled = new AtomicBoolean();

    public MultiOperatorProcessor(MultiSubscriber<? super O> downstream) {
        this.downstream = ParameterValidation.nonNull(downstream, "downstream");
    }

    void failAndCancel(Throwable throwable) {
        Subscription subscription = this.upstream.get();
        if (subscription != null) {
            subscription.cancel();
        }
        this.onFailure(throwable);
    }

    protected boolean isDone() {
        return this.upstream.get() == Subscriptions.CANCELLED;
    }

    protected boolean isCancelled() {
        return this.hasDownstreamCancelled.get();
    }

    public void onSubscribe(Subscription subscription) {
        if (this.upstream.compareAndSet(null, subscription)) {
            this.downstream.onSubscribe(this);
        } else {
            subscription.cancel();
        }
    }

    @Override
    public void onFailure(Throwable throwable) {
        Subscription subscription = this.upstream.getAndSet(Subscriptions.CANCELLED);
        if (subscription != Subscriptions.CANCELLED) {
            this.downstream.onFailure(throwable);
        } else {
            Infrastructure.handleDroppedException(throwable);
        }
    }

    @Override
    public void onItem(I item) {
        Subscription subscription = this.upstream.get();
        if (subscription != Subscriptions.CANCELLED) {
            this.downstream.onItem(item);
        }
    }

    @Override
    public void onCompletion() {
        Subscription subscription = this.upstream.getAndSet(Subscriptions.CANCELLED);
        if (subscription != Subscriptions.CANCELLED) {
            this.downstream.onCompletion();
        }
    }

    public void request(long numberOfItems) {
        Subscription subscription = this.upstream.get();
        if (subscription != Subscriptions.CANCELLED) {
            if (numberOfItems <= 0L) {
                this.onFailure(new IllegalArgumentException("Invalid number of request, must be greater than 0"));
                return;
            }
            subscription.request(numberOfItems);
        }
    }

    public void cancel() {
        if (this.hasDownstreamCancelled.compareAndSet(false, true)) {
            Subscriptions.cancel(this.upstream);
            this.cleanup();
        }
    }

    protected void cleanup() {
        this.downstream = null;
    }
}

