/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq.jms;

import org.apache.activemq.artemis.api.core.management.QueueControl;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.utils.SelectorTranslator;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.wildfly.extension.messaging.activemq.AbstractQueueControlHandler;
import org.wildfly.extension.messaging.activemq.OperationDefinitionHelper;
import org.wildfly.extension.messaging.activemq.jms.JMSManagementHelper;

public class JMSQueueControlHandler
extends AbstractQueueControlHandler<QueueControl> {
    public static final JMSQueueControlHandler INSTANCE = new JMSQueueControlHandler();
    private static final AttributeDefinition MESSAGE_ID = OperationDefinitionHelper.createNonEmptyStringAttribute("message-id");

    private JMSQueueControlHandler() {
    }

    @Override
    protected AttributeDefinition getMessageIDAttributeDefinition() {
        return MESSAGE_ID;
    }

    @Override
    protected AttributeDefinition[] getReplyMessageParameterDefinitions() {
        return JMSManagementHelper.JMS_MESSAGE_PARAMETERS;
    }

    @Override
    protected AbstractQueueControlHandler.DelegatingQueueControl<QueueControl> getQueueControl(ActiveMQServer server, String queueName) {
        final QueueControl control = (QueueControl)QueueControl.class.cast(server.getManagementService().getResource("queue.jms.queue." + queueName));
        if (control == null) {
            return null;
        }
        return new AbstractQueueControlHandler.DelegatingQueueControl<QueueControl>(){

            @Override
            public QueueControl getDelegate() {
                return control;
            }

            @Override
            public String listMessagesAsJSON(String filter) throws Exception {
                String result = control.listMessagesAsJSON(SelectorTranslator.convertToActiveMQFilterString((String)filter));
                return this.convertToJMSProperties(result);
            }

            @Override
            public long countMessages(String filter) throws Exception {
                return control.countMessages(SelectorTranslator.convertToActiveMQFilterString((String)filter));
            }

            @Override
            public boolean removeMessage(ModelNode id) throws Exception {
                int n = control.removeMessages(this.createFilterForJMSMessageID(id));
                return n == 1;
            }

            @Override
            public int removeMessages(String filter) throws Exception {
                return control.removeMessages(SelectorTranslator.convertToActiveMQFilterString((String)filter));
            }

            @Override
            public int expireMessages(String filter) throws Exception {
                return control.expireMessages(SelectorTranslator.convertToActiveMQFilterString((String)filter));
            }

            @Override
            public boolean expireMessage(ModelNode id) throws Exception {
                int n = control.expireMessages(this.createFilterForJMSMessageID(id));
                return n == 1;
            }

            @Override
            public boolean sendMessageToDeadLetterAddress(ModelNode id) throws Exception {
                int n = control.sendMessagesToDeadLetterAddress(this.createFilterForJMSMessageID(id));
                return n == 1;
            }

            @Override
            public int sendMessagesToDeadLetterAddress(String filter) throws Exception {
                return control.sendMessagesToDeadLetterAddress(SelectorTranslator.convertToActiveMQFilterString((String)filter));
            }

            @Override
            public boolean changeMessagePriority(ModelNode id, int priority) throws Exception {
                int n = control.changeMessagesPriority(this.createFilterForJMSMessageID(id), priority);
                return n == 1;
            }

            @Override
            public int changeMessagesPriority(String filter, int priority) throws Exception {
                return control.changeMessagesPriority(SelectorTranslator.convertToActiveMQFilterString((String)filter), priority);
            }

            @Override
            public boolean moveMessage(ModelNode id, String otherQueue) throws Exception {
                int n = control.moveMessages(this.createFilterForJMSMessageID(id), "jms.queue." + otherQueue);
                return n == 1;
            }

            @Override
            public boolean moveMessage(ModelNode id, String otherQueue, boolean rejectDuplicates) throws Exception {
                int n = control.moveMessages(this.createFilterForJMSMessageID(id), "jms.queue." + otherQueue, rejectDuplicates);
                return n == 1;
            }

            @Override
            public int moveMessages(String filter, String otherQueue) throws Exception {
                return control.moveMessages(SelectorTranslator.convertToActiveMQFilterString((String)filter), "jms.queue." + otherQueue);
            }

            @Override
            public int moveMessages(String filter, String otherQueue, boolean rejectDuplicates) throws Exception {
                return control.moveMessages(SelectorTranslator.convertToActiveMQFilterString((String)filter), "jms.queue." + otherQueue, rejectDuplicates);
            }

            @Override
            public String listMessageCounter() throws Exception {
                return control.listMessageCounter();
            }

            @Override
            public void resetMessageCounter() throws Exception {
                control.resetMessageCounter();
            }

            @Override
            public String listMessageCounterAsHTML() throws Exception {
                return control.listMessageCounterAsHTML();
            }

            @Override
            public String listMessageCounterHistory() throws Exception {
                return control.listMessageCounterHistory();
            }

            @Override
            public String listMessageCounterHistoryAsHTML() throws Exception {
                return control.listMessageCounterHistoryAsHTML();
            }

            @Override
            public void pause() throws Exception {
                control.pause();
            }

            @Override
            public void resume() throws Exception {
                control.resume();
            }

            @Override
            public String listConsumersAsJSON() throws Exception {
                return control.listConsumersAsJSON();
            }

            @Override
            public String listScheduledMessagesAsJSON() throws Exception {
                return control.listScheduledMessagesAsJSON();
            }

            @Override
            public String listDeliveringMessagesAsJSON() throws Exception {
                return control.listDeliveringMessagesAsJSON();
            }

            private String createFilterForJMSMessageID(ModelNode id) {
                return "AMQUserID='" + id.asString() + "'";
            }

            private String convertToJMSProperties(String text) {
                return text.replaceAll("priority", "JMSPriority").replaceAll("timestamp", "JMSTimestamp").replaceAll("expiration", "JMSExpiration").replaceAll("durable", "JMSDeliveryMode").replaceAll("userID", "JMSMessageID");
            }
        };
    }

    @Override
    protected Object handleAdditionalOperation(String operationName, ModelNode operation, OperationContext context, QueueControl queueControl) throws OperationFailedException {
        this.throwUnimplementedOperationException(operationName);
        return null;
    }

    @Override
    protected void revertAdditionalOperation(String operationName, ModelNode operation, OperationContext context, QueueControl queueControl, Object handback) {
    }
}

