/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.jaxrs2.server;

import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.contrib.jaxrs2.internal.CastUtils;
import io.opentracing.contrib.jaxrs2.internal.SpanWrapper;
import io.opentracing.contrib.jaxrs2.server.OperationNameProvider;
import io.opentracing.contrib.jaxrs2.server.ServerHeadersExtractTextMap;
import io.opentracing.contrib.jaxrs2.server.ServerSpanDecorator;
import io.opentracing.propagation.Format;
import io.opentracing.tag.Tags;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.annotation.Priority;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;

@Priority(value=3000)
public class ServerTracingFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    private static final Logger log = Logger.getLogger(ServerTracingFilter.class.getName());
    private Tracer tracer;
    private List<ServerSpanDecorator> spanDecorators;
    private String operationName;
    private OperationNameProvider operationNameProvider;
    private Pattern skipPattern;
    private final boolean joinExistingActiveSpan;
    @Context
    private HttpServletRequest httpServletRequest;

    protected ServerTracingFilter(Tracer tracer, String operationName, List<ServerSpanDecorator> spanDecorators, OperationNameProvider operationNameProvider, Pattern skipPattern, boolean joinExistingActiveSpan) {
        this.tracer = tracer;
        this.operationName = operationName;
        this.spanDecorators = new ArrayList<ServerSpanDecorator>(spanDecorators);
        this.operationNameProvider = operationNameProvider;
        this.skipPattern = skipPattern;
        this.joinExistingActiveSpan = joinExistingActiveSpan;
    }

    public void filter(ContainerRequestContext requestContext) {
        if (requestContext.getProperty(SpanWrapper.PROPERTY_NAME) != null || this.matchesSkipPattern(requestContext)) {
            return;
        }
        if (this.tracer != null) {
            SpanContext parentSpanContext = this.parentSpanContext(requestContext);
            Span span = this.tracer.buildSpan(this.operationNameProvider.operationName(requestContext)).ignoreActiveSpan().withTag(Tags.SPAN_KIND.getKey(), "server").asChildOf(parentSpanContext).start();
            if (this.spanDecorators != null) {
                for (ServerSpanDecorator decorator : this.spanDecorators) {
                    decorator.decorateRequest(requestContext, span);
                }
            }
            if (this.operationName != null) {
                span.setOperationName(this.operationName);
            }
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Creating server span: " + this.operationName);
            }
            requestContext.setProperty(SpanWrapper.PROPERTY_NAME, (Object)new SpanWrapper(span, this.tracer.activateSpan(span)));
        }
    }

    private SpanContext parentSpanContext(ContainerRequestContext requestContext) {
        Span activeSpan = this.tracer.activeSpan();
        if (activeSpan != null && this.joinExistingActiveSpan) {
            return activeSpan.context();
        }
        return this.tracer.extract(Format.Builtin.HTTP_HEADERS, (Object)new ServerHeadersExtractTextMap((MultivaluedMap<String, String>)requestContext.getHeaders()));
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) {
        SpanWrapper spanWrapper = CastUtils.cast(requestContext.getProperty(SpanWrapper.PROPERTY_NAME), SpanWrapper.class);
        if (spanWrapper == null) {
            return;
        }
        if (this.spanDecorators != null) {
            for (ServerSpanDecorator decorator : this.spanDecorators) {
                decorator.decorateResponse(responseContext, spanWrapper.get());
            }
        }
    }

    private boolean matchesSkipPattern(ContainerRequestContext requestContext) {
        String path = requestContext.getUriInfo().getPath();
        if (this.skipPattern != null && path != null) {
            if (path.length() > 0 && path.charAt(0) != '/') {
                path = "/" + path;
            }
            return this.skipPattern.matcher(path).matches();
        }
        return false;
    }
}

