/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.operations;

import java.util.Arrays;
import java.util.List;
import javax.net.ssl.SSLContext;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.management.BaseNativeInterfaceAddStepHandler;
import org.jboss.as.controller.management.NativeInterfaceCommonPolicy;
import org.jboss.as.host.controller.logging.HostControllerLogger;
import org.jboss.as.host.controller.operations.LocalHostControllerInfoImpl;
import org.jboss.as.host.controller.operations.NativeManagementServices;
import org.jboss.as.host.controller.resources.NativeManagementResourceDefinition;
import org.jboss.as.network.NetworkInterfaceBinding;
import org.jboss.as.remoting.RemotingServices;
import org.jboss.as.remoting.management.ManagementRemotingServices;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.security.auth.server.SaslAuthenticationFactory;
import org.xnio.OptionMap;

public class NativeManagementAddHandler
extends BaseNativeInterfaceAddStepHandler {
    public static final String OPERATION_NAME = "add";
    private final LocalHostControllerInfoImpl hostControllerInfo;

    public NativeManagementAddHandler(LocalHostControllerInfoImpl hostControllerInfo) {
        super(NativeManagementResourceDefinition.ATTRIBUTE_DEFINITIONS);
        this.hostControllerInfo = hostControllerInfo;
    }

    protected boolean requiresRuntime(OperationContext context) {
        return super.requiresRuntime(context) && context.getProcessType() != ProcessType.EMBEDDED_HOST_CONTROLLER;
    }

    protected List<ServiceName> installServices(OperationContext context, NativeInterfaceCommonPolicy commonPolicy, ModelNode model) throws OperationFailedException {
        NativeManagementAddHandler.populateHostControllerInfo(this.hostControllerInfo, context, model);
        ServiceTarget serviceTarget = context.getServiceTarget();
        boolean onDemand = context.isBooting();
        NativeManagementServices.installRemotingServicesIfNotInstalled(serviceTarget, this.hostControllerInfo.getLocalHostName(), context.getServiceRegistry(false), onDemand);
        OptionMap options = NativeManagementAddHandler.createConnectorOptions(commonPolicy);
        ServiceName nativeManagementInterfaceBinding = context.getCapabilityServiceName("org.wildfly.network.interface", this.hostControllerInfo.getNativeManagementInterface(), NetworkInterfaceBinding.class);
        String saslAuthenticationFactory = commonPolicy.getSaslAuthenticationFactory();
        if (saslAuthenticationFactory == null) {
            HostControllerLogger.ROOT_LOGGER.nativeManagementInterfaceIsUnsecured();
        }
        ServiceName saslAuthenticationFactoryName = saslAuthenticationFactory != null ? context.getCapabilityServiceName("org.wildfly.security.sasl-authentication-factory", saslAuthenticationFactory, SaslAuthenticationFactory.class) : null;
        String sslContext = commonPolicy.getSSLContext();
        ServiceName sslContextName = sslContext != null ? context.getCapabilityServiceName("org.wildfly.security.ssl-context", sslContext, SSLContext.class) : null;
        NativeManagementServices.installManagementWorkerService(serviceTarget, context.getServiceRegistry(false));
        ManagementRemotingServices.installDomainConnectorServices((OperationContext)context, (ServiceTarget)serviceTarget, (ServiceName)ManagementRemotingServices.MANAGEMENT_ENDPOINT, (ServiceName)nativeManagementInterfaceBinding, (int)this.hostControllerInfo.getNativeManagementPort(), (OptionMap)options, (ServiceName)saslAuthenticationFactoryName, (ServiceName)sslContextName);
        return Arrays.asList(RemotingServices.REMOTING_BASE.append(new String[]{"server", "management"}), nativeManagementInterfaceBinding);
    }

    private static void populateHostControllerInfo(LocalHostControllerInfoImpl hostControllerInfo, OperationContext context, ModelNode model) throws OperationFailedException {
        hostControllerInfo.setNativeManagementInterface(NativeManagementResourceDefinition.INTERFACE.resolveModelAttribute(context, model).asString());
        ModelNode portNode = NativeManagementResourceDefinition.NATIVE_PORT.resolveModelAttribute(context, model);
        hostControllerInfo.setNativeManagementPort(portNode.isDefined() ? portNode.asInt() : -1);
    }

    private static OptionMap createConnectorOptions(NativeInterfaceCommonPolicy commonPolicy) throws OperationFailedException {
        OptionMap.Builder builder = OptionMap.builder();
        builder.addAll(NativeManagementServices.CONNECTION_OPTIONS);
        builder.addAll(commonPolicy.getConnectorOptions());
        return builder.getMap();
    }
}

