/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.StandardCopyOption;
import java.util.Set;
import org.eclipse.jgit.internal.storage.file.FileObjectDatabase;
import org.eclipse.jgit.internal.storage.file.UnpackedObject;
import org.eclipse.jgit.internal.storage.file.UnpackedObjectCache;
import org.eclipse.jgit.internal.storage.file.WindowCursor;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LooseObjects {
    private static final Logger LOG = LoggerFactory.getLogger(LooseObjects.class);
    private final File directory;
    private final UnpackedObjectCache unpackedObjectCache;

    LooseObjects(File dir) {
        this.directory = dir;
        this.unpackedObjectCache = new UnpackedObjectCache();
    }

    File getDirectory() {
        return this.directory;
    }

    void create() throws IOException {
        FileUtils.mkdirs(this.directory);
    }

    void close() {
        this.unpackedObjectCache.clear();
    }

    public String toString() {
        return "LooseObjects[" + this.directory + "]";
    }

    boolean hasCached(AnyObjectId id) {
        return this.unpackedObjectCache.isUnpacked(id);
    }

    boolean has(AnyObjectId objectId) {
        return this.fileFor(objectId).exists();
    }

    boolean resolve(Set<ObjectId> matches, AbbreviatedObjectId id, int matchLimit) {
        String fanOut = id.name().substring(0, 2);
        String[] entries = new File(this.directory, fanOut).list();
        if (entries != null) {
            String[] stringArray = entries;
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                block7: {
                    String e = stringArray[n2];
                    if (e.length() == 38) {
                        block6: {
                            try {
                                ObjectId entId = ObjectId.fromString(String.valueOf(fanOut) + e);
                                if (id.prefixCompare(entId) != 0) break block6;
                                matches.add(entId);
                            }
                            catch (IllegalArgumentException notId) {
                                break block7;
                            }
                        }
                        if (matches.size() > matchLimit) {
                            return false;
                        }
                    }
                }
                ++n2;
            }
        }
        return true;
    }

    ObjectLoader open(WindowCursor curs, AnyObjectId id) throws IOException {
        File path = this.fileFor(id);
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (FileInputStream in = new FileInputStream(path);){
                this.unpackedObjectCache.add(id);
                return UnpackedObject.open(in, path, id, curs);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException noFile) {
            if (path.exists()) {
                throw noFile;
            }
            this.unpackedObjectCache.remove(id);
            return null;
        }
    }

    long getSize(WindowCursor curs, AnyObjectId id) throws IOException {
        File f = this.fileFor(id);
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (FileInputStream in = new FileInputStream(f);){
                this.unpackedObjectCache.add(id);
                return UnpackedObject.getSize(in, id, curs);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException noFile) {
            if (f.exists()) {
                throw noFile;
            }
            this.unpackedObjectCache.remove(id);
            return -1L;
        }
    }

    FileObjectDatabase.InsertLooseObjectResult insert(File tmp, ObjectId id) throws IOException {
        File dst = this.fileFor(id);
        if (dst.exists()) {
            FileUtils.delete(tmp, 2);
            return FileObjectDatabase.InsertLooseObjectResult.EXISTS_LOOSE;
        }
        try {
            return this.tryMove(tmp, dst, id);
        }
        catch (NoSuchFileException e) {
            FileUtils.mkdir(dst.getParentFile(), true);
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            FileUtils.delete(tmp, 2);
            return FileObjectDatabase.InsertLooseObjectResult.FAILURE;
        }
        try {
            return this.tryMove(tmp, dst, id);
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            FileUtils.delete(tmp, 2);
            return FileObjectDatabase.InsertLooseObjectResult.FAILURE;
        }
    }

    private FileObjectDatabase.InsertLooseObjectResult tryMove(File tmp, File dst, ObjectId id) throws IOException {
        Files.move(FileUtils.toPath(tmp), FileUtils.toPath(dst), StandardCopyOption.ATOMIC_MOVE);
        dst.setReadOnly();
        this.unpackedObjectCache.add(id);
        return FileObjectDatabase.InsertLooseObjectResult.INSERTED;
    }

    File fileFor(AnyObjectId objectId) {
        String n = objectId.name();
        String d = n.substring(0, 2);
        String f = n.substring(2);
        return new File(new File(this.getDirectory(), d), f);
    }
}

