/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream;

import java.io.IOException;
import java.util.OptionalInt;
import java.util.function.Supplier;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.ProtobufTagMarshaller;
import org.infinispan.protostream.impl.TagWriterImpl;
import org.wildfly.clustering.marshalling.protostream.AbstractProtoStreamWriter;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;

public class SizeComputingProtoStreamWriter
extends AbstractProtoStreamWriter
implements Supplier<OptionalInt> {
    private final TagWriterImpl writer;
    private boolean present = true;

    public SizeComputingProtoStreamWriter(ImmutableSerializationContext context) {
        this(TagWriterImpl.newInstance((ImmutableSerializationContext)context));
    }

    private SizeComputingProtoStreamWriter(TagWriterImpl writer) {
        super((ProtobufTagMarshaller.WriteContext)writer);
        this.writer = writer;
    }

    @Override
    public OptionalInt get() {
        return this.present ? OptionalInt.of(this.writer.getWrittenBytes()) : OptionalInt.empty();
    }

    @Override
    public void writeObjectNoTag(Object value) throws IOException {
        if (this.present) {
            ProtoStreamMarshaller marshaller = this.findMarshaller(value.getClass());
            SizeComputingProtoStreamWriter sizer = new SizeComputingProtoStreamWriter(this.getSerializationContext());
            marshaller.writeTo(sizer, value);
            OptionalInt size = sizer.get();
            if (size.isPresent()) {
                int length = size.getAsInt();
                this.writeVarint32(length);
                this.writeRawBytes(null, 0, length);
            } else {
                this.present = false;
            }
        }
    }
}

