/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.cosnaming;

import com.sun.jndi.cosnaming.CNCtx;
import com.sun.jndi.cosnaming.CNNameParser;
import com.sun.jndi.toolkit.corba.CorbaUtils;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.spi.NamingManager;
import org.omg.CosNaming.Binding;
import org.omg.CosNaming.BindingIterator;
import org.omg.CosNaming.BindingIteratorHolder;
import org.omg.CosNaming.BindingListHolder;
import org.omg.CosNaming.NameComponent;

final class CNBindingEnumeration
implements NamingEnumeration<javax.naming.Binding> {
    private static final int DEFAULT_BATCHSIZE = 100;
    private BindingListHolder _bindingList;
    private BindingIterator _bindingIter;
    private int counter;
    private int batchsize = 100;
    private CNCtx _ctx;
    private Hashtable<?, ?> _env;
    private boolean more = false;
    private boolean isLookedUpCtx = false;

    CNBindingEnumeration(CNCtx ctx, boolean isLookedUpCtx, Hashtable<?, ?> env) {
        String batch;
        String string = batch = env != null ? (String)env.get("java.naming.batchsize") : null;
        if (batch != null) {
            try {
                this.batchsize = Integer.parseInt(batch);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Batch size not numeric: " + batch);
            }
        }
        this._ctx = ctx;
        this._ctx.incEnumCount();
        this.isLookedUpCtx = isLookedUpCtx;
        this._env = env;
        this._bindingList = new BindingListHolder();
        BindingIteratorHolder _bindingIterH = new BindingIteratorHolder();
        this._ctx._nc.list(0, this._bindingList, _bindingIterH);
        this._bindingIter = _bindingIterH.value;
        this.more = this._bindingIter != null ? this._bindingIter.next_n(this.batchsize, this._bindingList) : false;
        this.counter = 0;
    }

    @Override
    public javax.naming.Binding next() throws NamingException {
        if (this.more && this.counter >= this._bindingList.value.length) {
            this.getMore();
        }
        if (this.more && this.counter < this._bindingList.value.length) {
            Binding bndg = this._bindingList.value[this.counter];
            ++this.counter;
            return this.mapBinding(bndg);
        }
        throw new NoSuchElementException();
    }

    @Override
    public boolean hasMore() throws NamingException {
        return this.more ? this.counter < this._bindingList.value.length || this.getMore() : false;
    }

    @Override
    public boolean hasMoreElements() {
        try {
            return this.hasMore();
        }
        catch (NamingException e) {
            return false;
        }
    }

    @Override
    public javax.naming.Binding nextElement() {
        try {
            return this.next();
        }
        catch (NamingException ne) {
            throw new NoSuchElementException();
        }
    }

    @Override
    public void close() throws NamingException {
        this.more = false;
        if (this._bindingIter != null) {
            this._bindingIter.destroy();
            this._bindingIter = null;
        }
        if (this._ctx != null) {
            this._ctx.decEnumCount();
            if (this.isLookedUpCtx) {
                this._ctx.close();
            }
            this._ctx = null;
        }
    }

    protected void finalize() {
        try {
            this.close();
        }
        catch (NamingException namingException) {
            // empty catch block
        }
    }

    private boolean getMore() throws NamingException {
        try {
            this.more = this._bindingIter.next_n(this.batchsize, this._bindingList);
            this.counter = 0;
        }
        catch (Exception e) {
            this.more = false;
            NamingException ne = new NamingException("Problem getting binding list");
            ne.setRootCause(e);
            throw ne;
        }
        return this.more;
    }

    private javax.naming.Binding mapBinding(Binding bndg) throws NamingException {
        Object obj = this._ctx.callResolve(bndg.binding_name);
        Name cname = CNNameParser.cosNameToName(bndg.binding_name);
        try {
            if (CorbaUtils.isObjectFactoryTrusted(obj)) {
                obj = NamingManager.getObjectInstance(obj, cname, this._ctx, this._env);
            }
        }
        catch (NamingException e) {
            throw e;
        }
        catch (Exception e) {
            NamingException ne = new NamingException("problem generating object using object factory");
            ne.setRootCause(e);
            throw ne;
        }
        String cnameStr = cname.toString();
        javax.naming.Binding jbndg = new javax.naming.Binding(cnameStr, obj);
        NameComponent[] comps = this._ctx.makeFullName(bndg.binding_name);
        String fullName = CNNameParser.cosNameToInsString(comps);
        jbndg.setNameInNamespace(fullName);
        return jbndg;
    }
}

