/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jbossts.star.client;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.Path;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import org.jboss.jbossts.star.annotation.Commit;
import org.jboss.jbossts.star.annotation.OnePhaseCommit;
import org.jboss.jbossts.star.annotation.Prepare;
import org.jboss.jbossts.star.annotation.Rollback;
import org.jboss.jbossts.star.annotation.SRA;
import org.jboss.jbossts.star.annotation.Status;
import org.jboss.jbossts.star.annotation.TimeLimit;
import org.jboss.jbossts.star.client.Current;
import org.jboss.jbossts.star.client.GenericSRAException;
import org.jboss.jbossts.star.client.IllegalSRAStateException;
import org.jboss.jbossts.star.client.SRAClient;
import org.jboss.logging.Logger;

@Provider
public class ServerSRAFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    protected static final Logger logger = Logger.getLogger(ServerSRAFilter.class);
    private SRAClient sraClient;
    private static final String CANCEL_ON_FAMILY_PROP = "CancelOnFamily";
    private static final String CANCEL_ON_PROP = "CancelOn";
    private static final String SUSPENDED_SRA_PROP = "suspendSRA";
    private static final String TERMINAL_SRA_PROP = "terminateSRA";
    private static final Boolean isTrace = Boolean.getBoolean("trace");
    @Context
    protected ResourceInfo resourceInfo;

    private void checkForTx(SRA.Type type, URL sraId, boolean shouldNotBeNull) {
        if (sraId == null && shouldNotBeNull) {
            throw new GenericSRAException(null, Response.Status.PRECONDITION_FAILED.getStatusCode(), type.name() + " but no tx", null);
        }
        if (sraId != null && !shouldNotBeNull) {
            throw new GenericSRAException(sraId, Response.Status.PRECONDITION_FAILED.getStatusCode(), type.name() + " but found tx", null);
        }
    }

    public void filter(ContainerRequestContext containerRequestContext) throws IOException {
        URL sraId;
        boolean endAnnotation;
        boolean delayCommit;
        Method method = this.resourceInfo.getResourceMethod();
        MultivaluedMap headers = containerRequestContext.getHeaders();
        SRA.Type type = null;
        SRA transactional = method.getDeclaredAnnotation(SRA.class);
        URL newSRA = null;
        URL suspendedSRA = null;
        URL incommingSRA = null;
        String recoveryUrl = null;
        if (transactional == null) {
            transactional = method.getDeclaringClass().getDeclaredAnnotation(SRA.class);
        }
        if (transactional != null) {
            type = transactional.value();
            delayCommit = transactional.delayCommit();
            Response.Status.Family[] cancel0nFamily = new Response.Status.Family[]{Response.Status.Family.SERVER_ERROR};
            Response.Status[] cancel0n = new Response.Status[]{};
            containerRequestContext.setProperty(CANCEL_ON_FAMILY_PROP, (Object)cancel0nFamily);
            containerRequestContext.setProperty(CANCEL_ON_PROP, (Object)cancel0n);
        } else {
            delayCommit = false;
        }
        if (type == null) {
            Current.clearContext((MultivaluedMap<String, String>)headers);
            return;
        }
        boolean enlist = true;
        boolean bl = endAnnotation = method.isAnnotationPresent(Commit.class) || method.isAnnotationPresent(Prepare.class) || method.isAnnotationPresent(OnePhaseCommit.class);
        if (headers.containsKey((Object)"Short-Running-Action")) {
            incommingSRA = new URL((String)headers.getFirst((Object)"Short-Running-Action"));
        }
        if (endAnnotation && incommingSRA == null) {
            return;
        }
        switch (type) {
            case MANDATORY: {
                this.checkForTx(type, incommingSRA, true);
                sraId = incommingSRA;
                this.resumeTransaction(incommingSRA);
                break;
            }
            case NEVER: {
                this.checkForTx(type, incommingSRA, false);
                enlist = false;
                sraId = null;
                break;
            }
            case NOT_SUPPORTED: {
                enlist = false;
                suspendedSRA = incommingSRA;
                sraId = null;
                break;
            }
            case REQUIRED: {
                if (incommingSRA != null) {
                    sraId = incommingSRA;
                    this.resumeTransaction(incommingSRA);
                    break;
                }
                this.sraTrace(containerRequestContext, null, "ServerSRAFilter before: REQUIRED start new SRA");
                newSRA = sraId = this.startSRA(null, method, this.getTimeOut(method));
                break;
            }
            case REQUIRES_NEW: {
                suspendedSRA = incommingSRA;
                this.sraTrace(containerRequestContext, suspendedSRA, "ServerSRAFilter before: REQUIRES_NEW start new SRA");
                newSRA = sraId = this.startSRA(incommingSRA, method, this.getTimeOut(method));
                break;
            }
            case SUPPORTS: {
                sraId = incommingSRA;
                if (incommingSRA == null) break;
                this.resumeTransaction(incommingSRA);
                break;
            }
            default: {
                sraId = incommingSRA;
            }
        }
        if (sraId == null) {
            this.sraTrace(containerRequestContext, sraId, "ServerSRAFilter before: removing header");
            Current.clearContext((MultivaluedMap<String, String>)headers);
            if (suspendedSRA != null) {
                containerRequestContext.setProperty(SUSPENDED_SRA_PROP, (Object)suspendedSRA);
            }
            return;
        }
        this.sraTrace(containerRequestContext, sraId, "ServerSRAFilter before: adding header");
        if (!delayCommit) {
            containerRequestContext.setProperty(TERMINAL_SRA_PROP, (Object)sraId);
            newSRA = null;
        }
        Current.updateSRAContext(sraId, (MultivaluedMap<String, String>)headers);
        if (newSRA != null && suspendedSRA != null) {
            containerRequestContext.setProperty(SUSPENDED_SRA_PROP, (Object)incommingSRA);
        }
        this.sraTrace(containerRequestContext, sraId, "ServerSRAFilter before: making SRA available to injected SRAClient");
        this.getSRAClient().setCurrentSRA(sraId);
        if (!endAnnotation && enlist) {
            Map<String, String> terminateURIs = this.getSRAClient().getTerminationUris(sraId, this.resourceInfo.getResourceClass(), containerRequestContext.getUriInfo(), true);
            String timeLimitStr = terminateURIs.get("TimeLimit");
            long timeLimit = timeLimitStr == null ? 0L : Long.parseLong(timeLimitStr);
            try {
                recoveryUrl = this.getSRAClient().joinSRAWithLinkHeader(sraId, timeLimit, terminateURIs.get("Link"));
            }
            catch (IllegalSRAStateException e) {
                this.sraTrace(containerRequestContext, sraId, "ServerSRAFilter before: aborting with " + e.getMessage());
                throw e;
            }
            catch (WebApplicationException e) {
                this.sraTrace(containerRequestContext, sraId, "ServerSRAFilter before: aborting with " + e.getMessage());
                throw new GenericSRAException(sraId, e.getResponse().getStatus(), e.getMessage(), e);
            }
            headers.putSingle((Object)"Short-Running-Action-Recovery", (Object)recoveryUrl);
        }
        this.sraTrace(containerRequestContext, sraId, "ServerSRAFilter before: making SRA available as a thread local");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) {
        block28: {
            Object suspendedSRA = requestContext.getProperty(SUSPENDED_SRA_PROP);
            URL current = Current.peek();
            URL toClose = (URL)requestContext.getProperty(TERMINAL_SRA_PROP);
            boolean isCancel = this.isJaxRsCancel(requestContext, responseContext);
            try {
                block29: {
                    if (current != null && isCancel) {
                        try {
                            this.getSRAClient().cancelSRA(current);
                        }
                        catch (NotFoundException notFoundException) {
                        }
                        catch (WebApplicationException webApplicationException) {
                        }
                        catch (ProcessingException e) {
                            Method method = this.resourceInfo.getResourceMethod();
                            logger.warnf("ProcessingException: " + e.getMessage(), (Object)(method.getDeclaringClass().getName() + "#" + method.getName()), (Object)current.toString());
                            toClose = null;
                        }
                        finally {
                            if (current.toString().equals(Current.getLast((List)requestContext.getHeaders().get((Object)"Short-Running-Action")))) {
                                requestContext.getHeaders().remove((Object)"Short-Running-Action");
                            }
                            if (toClose != null && toClose.toString().equals(current.toString())) {
                                toClose = null;
                            }
                        }
                    }
                    if (toClose == null) break block28;
                    try {
                        if (isCancel) {
                            this.getSRAClient().cancelSRA(toClose);
                            break block29;
                        }
                        this.getSRAClient().commitSRA(toClose);
                    }
                    catch (NotFoundException notFoundException) {
                        requestContext.getHeaders().remove((Object)"Short-Running-Action");
                        if (toClose.toString().equals(Current.getLast((List)requestContext.getHeaders().get((Object)"Short-Running-Action")))) {
                            requestContext.getHeaders().remove((Object)"Short-Running-Action");
                        }
                        break block28;
                    }
                    catch (ProcessingException | WebApplicationException throwable) {
                        requestContext.getHeaders().remove((Object)"Short-Running-Action");
                        if (toClose.toString().equals(Current.getLast((List)requestContext.getHeaders().get((Object)"Short-Running-Action")))) {
                            requestContext.getHeaders().remove((Object)"Short-Running-Action");
                        }
                        break block28;
                        {
                            catch (Throwable throwable2) {
                                requestContext.getHeaders().remove((Object)"Short-Running-Action");
                                if (toClose.toString().equals(Current.getLast((List)requestContext.getHeaders().get((Object)"Short-Running-Action")))) {
                                    requestContext.getHeaders().remove((Object)"Short-Running-Action");
                                }
                                throw throwable2;
                            }
                        }
                    }
                }
                requestContext.getHeaders().remove((Object)"Short-Running-Action");
                if (toClose.toString().equals(Current.getLast((List)requestContext.getHeaders().get((Object)"Short-Running-Action")))) {
                    requestContext.getHeaders().remove((Object)"Short-Running-Action");
                }
            }
            finally {
                if (suspendedSRA != null) {
                    Current.push((URL)suspendedSRA);
                }
                Current.popAll();
            }
        }
    }

    private boolean isJaxRsCancel(ContainerRequestContext requestContext, ContainerResponseContext responseContext) {
        int status = responseContext.getStatus();
        Response.Status.Family[] cancel0nFamily = (Response.Status.Family[])requestContext.getProperty(CANCEL_ON_FAMILY_PROP);
        Response.Status[] cancel0n = (Response.Status[])requestContext.getProperty(CANCEL_ON_PROP);
        if (cancel0nFamily != null && Arrays.stream(cancel0nFamily).anyMatch(f -> Response.Status.Family.familyOf((int)status) == f)) {
            return true;
        }
        if (cancel0n != null) {
            return Arrays.stream(cancel0n).anyMatch(f -> status == f.getStatusCode());
        }
        return false;
    }

    private long getTimeOut(Method method) {
        TimeLimit timeLimit = method.getDeclaredAnnotation(TimeLimit.class);
        if (timeLimit == null && (timeLimit = method.getDeclaringClass().getDeclaredAnnotation(TimeLimit.class)) == null) {
            return 0L;
        }
        return timeLimit.unit().toMillis(timeLimit.limit());
    }

    private SRAClient getSRAClient() {
        if (this.sraClient == null) {
            try {
                this.sraClient = new SRAClient();
            }
            catch (MalformedURLException | URISyntaxException e) {
                throw new GenericSRAException(null, Response.Status.PRECONDITION_FAILED.getStatusCode(), e.getMessage(), e);
            }
        }
        return this.sraClient;
    }

    private URL startSRA(URL parentSRA, Method method, long timeout) {
        String clientId = method.getDeclaringClass().getName() + "#" + method.getName();
        return this.getSRAClient().startSRA(parentSRA, clientId, timeout, TimeUnit.MILLISECONDS);
    }

    private void resumeTransaction(URL sraId) {
    }

    private StringBuilder getParticipantLink(StringBuilder b, String uriPrefix, String key, String value) {
        String terminationUri = String.format("%s%s", uriPrefix, value);
        Link link = Link.fromUri((String)terminationUri).title(key + " URI").rel(key).type("text/plain").build(new Object[0]);
        if (b.length() != 0) {
            b.append(',');
        }
        return b.append(link);
    }

    private String getCompensatorId(URL sraId, URI baseUri) {
        Map<String, String> terminateURIs = this.getTerminationUris(this.resourceInfo.getResourceClass());
        if (terminateURIs.size() < 3) {
            throw new GenericSRAException(sraId, Response.Status.BAD_REQUEST.getStatusCode(), "Missing complete, compensate or status annotations", null);
        }
        StringBuilder linkHeaderValue = new StringBuilder();
        Path resourcePathAnnotation = this.resourceInfo.getResourceClass().getAnnotation(Path.class);
        String resourcePath = resourcePathAnnotation == null ? "/" : resourcePathAnnotation.value();
        String uriPrefix = String.format("%s:%s%s", baseUri.getScheme(), baseUri.getSchemeSpecificPart(), resourcePath.substring(1));
        terminateURIs.forEach((k, v) -> this.getParticipantLink(linkHeaderValue, uriPrefix, (String)k, (String)v));
        return linkHeaderValue.toString();
    }

    private Map<String, String> getTerminationUris(Class<?> compensatorClass) {
        HashMap<String, String> paths = new HashMap<String, String>();
        Arrays.stream(compensatorClass.getMethods()).forEach(method -> {
            Path pathAnnotation = method.getAnnotation(Path.class);
            if (pathAnnotation != null) {
                this.checkMethod(paths, "commit", pathAnnotation, method.getAnnotation(Commit.class));
                this.checkMethod(paths, "prepare", pathAnnotation, method.getAnnotation(Prepare.class));
                this.checkMethod(paths, "rollback", pathAnnotation, method.getAnnotation(Rollback.class));
                this.checkMethod(paths, "participant", pathAnnotation, method.getAnnotation(Status.class));
                this.checkMethod(paths, "onephasecommit", pathAnnotation, method.getAnnotation(OnePhaseCommit.class));
            }
        });
        return paths;
    }

    private void checkMethod(Map<String, String> paths, String rel, Path pathAnnotation, Annotation annotationClass) {
        if (annotationClass != null) {
            paths.put(rel, pathAnnotation.value());
        }
    }

    protected void sraTrace(ContainerRequestContext context, URL sraId, String reason) {
        if (isTrace.booleanValue()) {
            Method method = this.resourceInfo.getResourceMethod();
            System.out.printf("%s: container request for method %s: sra: %s%n", reason, method.getDeclaringClass().getName() + "#" + method.getName(), sraId == null ? "context" : sraId);
        }
    }
}

