/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean.proxy.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.weld.exceptions.UnsupportedOperationException;
import org.jboss.weld.logging.BeanLogger;
import org.jboss.weld.serialization.spi.ProxyServices;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class WeldDefaultProxyServices
implements ProxyServices {
    private static Method defineClass1;
    private static Method defineClass2;
    private static final AtomicBoolean classLoaderMethodsMadeAccessible;

    public static void makeClassLoaderMethodsAccessible() {
        if (classLoaderMethodsMadeAccessible.compareAndSet(false, true)) {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws Exception {
                        Class<?> cl = Class.forName("java.lang.ClassLoader");
                        String name = "defineClass";
                        defineClass1 = cl.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
                        defineClass2 = cl.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE, ProtectionDomain.class);
                        defineClass1.setAccessible(true);
                        defineClass2.setAccessible(true);
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                throw new RuntimeException("cannot initialize ClassPool", pae.getException());
            }
        }
    }

    public ClassLoader getClassLoader(Class<?> proxiedBeanType) {
        throw new UnsupportedOperationException("WeldDefaultProxyServices.getClassLoader(Class<?>) is not implemented.");
    }

    public Class<?> loadBeanClass(String className) {
        throw new UnsupportedOperationException("WeldDefaultProxyServices.loadBeanClass(String) is not implemented.");
    }

    public Class<?> defineClass(Class<?> originalClass, String className, byte[] classBytes, int off, int len) throws ClassFormatError {
        return this.defineClass(originalClass, className, classBytes, off, len, null);
    }

    public Class<?> defineClass(Class<?> originalClass, String className, byte[] classBytes, int off, int len, ProtectionDomain protectionDomain) throws ClassFormatError {
        try {
            Object[] args;
            Method method;
            if (protectionDomain == null) {
                method = defineClass1;
                args = new Object[]{className, classBytes, 0, len};
            } else {
                method = defineClass2;
                args = new Object[]{className, classBytes, 0, len, protectionDomain};
            }
            ClassLoader loader = originalClass.getClassLoader();
            if (loader == null && (loader = Thread.currentThread().getContextClassLoader()) == null) {
                throw BeanLogger.LOG.cannotDetermineClassLoader(className, originalClass);
            }
            Class clazz = (Class)method.invoke((Object)loader, args);
            return clazz;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getTargetException());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Class<?> loadClass(Class<?> originalClass, String classBinaryName) throws ClassNotFoundException {
        ClassLoader loader = originalClass.getClassLoader();
        if (loader == null && (loader = Thread.currentThread().getContextClassLoader()) == null) {
            throw BeanLogger.LOG.cannotDetermineClassLoader(classBinaryName, originalClass);
        }
        return loader.loadClass(classBinaryName);
    }

    public boolean supportsClassDefining() {
        return true;
    }

    public void cleanup() {
    }

    static {
        classLoaderMethodsMadeAccessible = new AtomicBoolean(false);
    }
}

