/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.statetransfer;

import java.util.Collection;
import java.util.Objects;
import net.jcip.annotations.GuardedBy;
import org.infinispan.configuration.cache.BackupConfiguration;
import org.infinispan.configuration.cache.XSiteStateTransferMode;
import org.infinispan.remoting.transport.Address;
import org.infinispan.xsite.XSiteBackup;
import org.infinispan.xsite.statetransfer.StateTransferStatus;
import org.infinispan.xsite.statetransfer.XSiteStateTransferCollector;

public class RemoteSiteStatus {
    private final XSiteBackup backup;
    private final boolean isSync;
    @GuardedBy(value="this")
    private StateTransferStatus status;
    @GuardedBy(value="this")
    private XSiteStateTransferCollector collector;
    @GuardedBy(value="this")
    private XSiteStateTransferMode stateTransferMode;

    private RemoteSiteStatus(XSiteBackup backup, boolean isSync, XSiteStateTransferMode stateTransferMode) {
        this.backup = Objects.requireNonNull(backup);
        this.isSync = isSync;
        this.stateTransferMode = stateTransferMode;
        this.status = StateTransferStatus.IDLE;
    }

    public XSiteBackup getBackup() {
        return this.backup;
    }

    public boolean isSync() {
        return this.isSync;
    }

    public String getSiteName() {
        return this.backup.getSiteName();
    }

    public synchronized StateTransferStatus getStatus() {
        return this.status;
    }

    public synchronized void clearStatus() {
        if (this.collector == null) {
            this.status = StateTransferStatus.IDLE;
        }
    }

    public synchronized boolean startStateTransfer(Collection<Address> members) {
        if (this.collector != null) {
            return false;
        }
        this.collector = new XSiteStateTransferCollector(members);
        this.status = StateTransferStatus.SENDING;
        return true;
    }

    public synchronized boolean restartStateTransfer(Collection<Address> newMembers) {
        if (this.collector == null) {
            return false;
        }
        this.collector = new XSiteStateTransferCollector(newMembers);
        return true;
    }

    public synchronized boolean confirmStateTransfer(Address node, boolean statusOk) {
        if (this.collector == null) {
            return false;
        }
        if (this.collector.confirmStateTransfer(node, statusOk)) {
            this.status = statusOk ? StateTransferStatus.SEND_OK : StateTransferStatus.SEND_FAILED;
            this.collector = null;
            return true;
        }
        return false;
    }

    public synchronized void cancelStateTransfer() {
        if (this.collector == null) {
            return;
        }
        this.collector = null;
        this.status = StateTransferStatus.SEND_CANCELED;
    }

    public synchronized boolean isStateTransferInProgress() {
        return this.collector != null;
    }

    public synchronized void failStateTransfer() {
        if (this.collector == null) {
            return;
        }
        this.collector = null;
        this.status = StateTransferStatus.SEND_FAILED;
    }

    public static RemoteSiteStatus fromConfiguration(BackupConfiguration configuration) {
        XSiteBackup backup = new XSiteBackup(configuration.site(), true, configuration.replicationTimeout());
        return new RemoteSiteStatus(backup, configuration.isSyncBackup(), configuration.stateTransfer().mode());
    }

    public XSiteStateTransferMode stateTransferMode() {
        return this.stateTransferMode;
    }

    public boolean setStateTransferMode(XSiteStateTransferMode mode) {
        if (this.isSync) {
            return false;
        }
        this.stateTransferMode = mode;
        return true;
    }
}

