/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.batchindexing.impl;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import org.hibernate.search.batchindexing.MassIndexerProgressMonitor;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class SimpleIndexingProgressMonitor
implements MassIndexerProgressMonitor {
    private static final Log log = LoggerFactory.make((MethodHandles.Lookup)MethodHandles.lookup());
    private final AtomicLong documentsDoneCounter = new AtomicLong();
    private final LongAdder totalCounter = new LongAdder();
    private volatile long startTime;
    private final int logAfterNumberOfDocuments;

    public SimpleIndexingProgressMonitor() {
        this(50);
    }

    public SimpleIndexingProgressMonitor(int logAfterNumberOfDocuments) {
        this.logAfterNumberOfDocuments = logAfterNumberOfDocuments;
    }

    public void entitiesLoaded(int size) {
    }

    public void documentsAdded(long increment) {
        long current = this.documentsDoneCounter.addAndGet(increment);
        if (current == increment) {
            this.startTime = System.nanoTime();
        }
        if (current % (long)this.getStatusMessagePeriod() == 0L) {
            this.printStatusMessage(this.startTime, this.totalCounter.longValue(), current);
        }
    }

    public void documentsBuilt(int number) {
    }

    public void addToTotalCount(long count) {
        this.totalCounter.add(count);
        log.indexingEntities(count);
    }

    public void indexingCompleted() {
        log.indexingEntitiesCompleted(this.totalCounter.longValue());
    }

    protected int getStatusMessagePeriod() {
        return this.logAfterNumberOfDocuments;
    }

    protected void printStatusMessage(long startTime, long totalTodoCount, long doneCount) {
        long elapsedMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime);
        log.indexingDocumentsCompleted(doneCount, elapsedMs);
        float estimateSpeed = (float)doneCount * 1000.0f / (float)elapsedMs;
        float estimatePercentileComplete = (float)doneCount * 100.0f / (float)totalTodoCount;
        log.indexingSpeed(estimateSpeed, estimatePercentileComplete);
    }
}

