/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.grpc.ConnectivityState;
import io.grpc.ConnectivityStateInfo;
import io.grpc.LoadBalancer;
import io.grpc.Status;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

final class PickFirstLoadBalancer
extends LoadBalancer {
    private final LoadBalancer.Helper helper;
    private LoadBalancer.Subchannel subchannel;

    PickFirstLoadBalancer(LoadBalancer.Helper helper) {
        this.helper = (LoadBalancer.Helper)Preconditions.checkNotNull((Object)helper, (Object)"helper");
    }

    public void handleResolvedAddresses(LoadBalancer.ResolvedAddresses resolvedAddresses) {
        List servers = resolvedAddresses.getAddresses();
        if (this.subchannel == null) {
            final LoadBalancer.Subchannel subchannel = this.helper.createSubchannel(LoadBalancer.CreateSubchannelArgs.newBuilder().setAddresses(servers).build());
            subchannel.start(new LoadBalancer.SubchannelStateListener(){

                public void onSubchannelState(ConnectivityStateInfo stateInfo) {
                    PickFirstLoadBalancer.this.processSubchannelState(subchannel, stateInfo);
                }
            });
            this.subchannel = subchannel;
            this.helper.updateBalancingState(ConnectivityState.CONNECTING, (LoadBalancer.SubchannelPicker)new Picker(LoadBalancer.PickResult.withSubchannel((LoadBalancer.Subchannel)subchannel)));
            subchannel.requestConnection();
        } else {
            this.subchannel.updateAddresses(servers);
        }
    }

    public void handleNameResolutionError(Status error) {
        if (this.subchannel != null) {
            this.subchannel.shutdown();
            this.subchannel = null;
        }
        this.helper.updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, (LoadBalancer.SubchannelPicker)new Picker(LoadBalancer.PickResult.withError((Status)error)));
    }

    private void processSubchannelState(LoadBalancer.Subchannel subchannel, ConnectivityStateInfo stateInfo) {
        LoadBalancer.SubchannelPicker picker;
        ConnectivityState currentState = stateInfo.getState();
        if (currentState == ConnectivityState.SHUTDOWN) {
            return;
        }
        switch (currentState) {
            case IDLE: {
                picker = new RequestConnectionPicker(subchannel);
                break;
            }
            case CONNECTING: {
                picker = new Picker(LoadBalancer.PickResult.withNoResult());
                break;
            }
            case READY: {
                picker = new Picker(LoadBalancer.PickResult.withSubchannel((LoadBalancer.Subchannel)subchannel));
                break;
            }
            case TRANSIENT_FAILURE: {
                picker = new Picker(LoadBalancer.PickResult.withError((Status)stateInfo.getStatus()));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported state:" + currentState);
            }
        }
        this.helper.updateBalancingState(currentState, picker);
    }

    public void shutdown() {
        if (this.subchannel != null) {
            this.subchannel.shutdown();
        }
    }

    public void requestConnection() {
        if (this.subchannel != null) {
            this.subchannel.requestConnection();
        }
    }

    private final class RequestConnectionPicker
    extends LoadBalancer.SubchannelPicker {
        private final LoadBalancer.Subchannel subchannel;
        private final AtomicBoolean connectionRequested = new AtomicBoolean(false);

        RequestConnectionPicker(LoadBalancer.Subchannel subchannel) {
            this.subchannel = (LoadBalancer.Subchannel)Preconditions.checkNotNull((Object)subchannel, (Object)"subchannel");
        }

        public LoadBalancer.PickResult pickSubchannel(LoadBalancer.PickSubchannelArgs args) {
            if (this.connectionRequested.compareAndSet(false, true)) {
                PickFirstLoadBalancer.this.helper.getSynchronizationContext().execute(new Runnable(){

                    @Override
                    public void run() {
                        RequestConnectionPicker.this.subchannel.requestConnection();
                    }
                });
            }
            return LoadBalancer.PickResult.withNoResult();
        }
    }

    private static final class Picker
    extends LoadBalancer.SubchannelPicker {
        private final LoadBalancer.PickResult result;

        Picker(LoadBalancer.PickResult result) {
            this.result = (LoadBalancer.PickResult)Preconditions.checkNotNull((Object)result, (Object)"result");
        }

        public LoadBalancer.PickResult pickSubchannel(LoadBalancer.PickSubchannelArgs args) {
            return this.result;
        }

        public String toString() {
            return MoreObjects.toStringHelper(Picker.class).add("result", (Object)this.result).toString();
        }
    }
}

