/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.util;

import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.SaslException;
import org.wildfly.common.Assert;
import org.wildfly.security.sasl._private.ElytronMessages;
import org.wildfly.security.sasl.util.SaslWrapper;

public abstract class AbstractSaslParticipant
implements SaslWrapper {
    public static final byte[] NO_BYTES = new byte[0];
    public static final int FAILED_STATE = -1;
    public static final int COMPLETE_STATE = 0;
    private final String mechanismName;
    private final CallbackHandler callbackHandler;
    private final String protocol;
    private final String serverName;
    private org.wildfly.security.mechanism._private.ElytronMessages log;
    private ElytronMessages legacyLog;
    private int state = -1;
    private SaslWrapper wrapper;

    protected AbstractSaslParticipant(String mechanismName, String protocol, String serverName, CallbackHandler callbackHandler, org.wildfly.security.mechanism._private.ElytronMessages log) {
        this.callbackHandler = callbackHandler;
        this.mechanismName = mechanismName;
        this.protocol = protocol;
        this.serverName = serverName;
        this.log = log;
    }

    @Deprecated
    protected AbstractSaslParticipant(String mechanismName, String protocol, String serverName, CallbackHandler callbackHandler) {
        this.callbackHandler = callbackHandler;
        this.mechanismName = mechanismName;
        this.protocol = protocol;
        this.serverName = serverName;
        this.legacyLog = ElytronMessages.sasl;
    }

    protected void handleCallbacks(Callback ... callbacks) throws SaslException {
        try {
            this.tryHandleCallbacks(callbacks);
        }
        catch (UnsupportedCallbackException e) {
            throw this.log != null ? this.log.mechCallbackHandlerFailedForUnknownReason((Throwable)e).toSaslException() : this.legacyLog.mechCallbackHandlerFailedForUnknownReason(e).toSaslException();
        }
    }

    protected void tryHandleCallbacks(Callback ... callbacks) throws SaslException, UnsupportedCallbackException {
        Assert.checkNotNullParam((String)"callbackHandler", (Object)this.callbackHandler);
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (UnsupportedCallbackException | SaslException e) {
            throw e;
        }
        catch (Throwable t) {
            throw this.log != null ? this.log.mechCallbackHandlerFailedForUnknownReason(t).toSaslException() : this.legacyLog.mechCallbackHandlerFailedForUnknownReason(t).toSaslException();
        }
    }

    public void init() {
    }

    public String getMechanismName() {
        return this.mechanismName;
    }

    protected String getProtocol() {
        return this.protocol;
    }

    protected String getServerName() {
        return this.serverName;
    }

    protected CallbackHandler getCallbackHandler() {
        return this.callbackHandler;
    }

    protected SaslWrapper getWrapper() {
        return this.wrapper;
    }

    public void setNegotiationState(int newState) {
        this.state = newState;
    }

    public void negotiationComplete() {
        this.state = 0;
        String msg = "SASL Negotiation Completed";
        if (this.log != null) {
            this.log.tracef("SASL Negotiation Completed", new Object[0]);
        } else {
            this.legacyLog.tracef("SASL Negotiation Completed", new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] evaluateMessage(byte[] message) throws SaslException {
        boolean ok = false;
        try {
            if (this.state == 0) {
                throw this.log != null ? this.log.mechMessageAfterComplete().toSaslException() : this.legacyLog.mechMessageAfterComplete().toSaslException();
            }
            if (this.state == -1) {
                throw this.log != null ? this.log.mechAuthenticationFailed().toSaslException() : this.legacyLog.mechAuthenticationFailed().toSaslException();
            }
            byte[] result = this.evaluateMessage(this.state, message);
            ok = true;
            byte[] byArray = result;
            return byArray;
        }
        finally {
            if (!ok) {
                this.state = -1;
                String msg = "SASL Negotiation Failed";
                if (this.log != null) {
                    this.log.tracef("SASL Negotiation Failed", new Object[0]);
                } else {
                    this.legacyLog.tracef("SASL Negotiation Failed", new Object[0]);
                }
            }
        }
    }

    protected abstract byte[] evaluateMessage(int var1, byte[] var2) throws SaslException;

    protected void setWrapper(SaslWrapper wrapper) {
        this.wrapper = wrapper;
    }

    @Override
    public byte[] wrap(byte[] outgoing, int offset, int len) throws SaslException {
        if (!this.isComplete()) {
            throw this.log != null ? this.log.mechAuthenticationNotComplete() : this.legacyLog.mechAuthenticationNotComplete();
        }
        SaslWrapper wrapper = this.wrapper;
        if (wrapper == null) {
            throw this.log != null ? this.log.wrappingNotConfigured() : this.legacyLog.wrappingNotConfigured();
        }
        if (len == 0) {
            return NO_BYTES;
        }
        return wrapper.wrap(outgoing, offset, len);
    }

    @Override
    public byte[] unwrap(byte[] incoming, int offset, int len) throws SaslException {
        if (!this.isComplete()) {
            throw this.log.mechAuthenticationNotComplete();
        }
        SaslWrapper wrapper = this.wrapper;
        if (wrapper == null) {
            throw this.log.wrappingNotConfigured();
        }
        if (len == 0) {
            return NO_BYTES;
        }
        return wrapper.unwrap(incoming, offset, len);
    }

    public boolean isComplete() {
        return this.state == 0;
    }

    protected void assertComplete() {
        if (!this.isComplete()) {
            throw this.log.mechAuthenticationNotComplete();
        }
    }

    public Object getNegotiatedProperty(String propName) {
        this.assertComplete();
        return null;
    }

    public String getStringProperty(Map<String, ?> map, String key, String defaultVal) {
        Object val = map.get(key);
        if (val == null) {
            return defaultVal;
        }
        return String.valueOf(val);
    }

    public int getIntProperty(Map<String, ?> map, String key, int defaultVal) {
        Object val = map.get(key);
        if (val == null) {
            return defaultVal;
        }
        return Integer.parseInt(val.toString());
    }

    public void dispose() throws SaslException {
    }
}

