/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.ServiceLoader;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.server.controller.resources.DeploymentAttributes;
import org.jboss.as.server.deployment.DeploymentAddHandler;
import org.jboss.as.server.deployment.DeploymentHandlerUtils;
import org.jboss.as.server.deployment.transformation.DeploymentTransformer;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.dmr.ModelNode;

class DeploymentTransformation {
    private final DeploymentTransformer deploymentTransformer = DeploymentTransformation.loadDeploymentTransformer();

    private static DeploymentTransformer loadDeploymentTransformer() {
        Iterator<DeploymentTransformer> iter = ServiceLoader.load(DeploymentTransformer.class, DeploymentAddHandler.class.getClassLoader()).iterator();
        return iter.hasNext() ? iter.next() : null;
    }

    public InputStream doTransformation(OperationContext context, ModelNode contentItemNode, String name, InputStream in) throws IOException, OperationFailedException {
        if (this.deploymentTransformer == null) {
            return in;
        }
        try {
            return this.deploymentTransformer.transform(in, name);
        }
        catch (RuntimeException t) {
            if (!contentItemNode.hasDefined(DeploymentAttributes.CONTENT_INPUT_STREAM_INDEX.getName()) && t.getCause() != null && t.getCause().getCause() != null && t.getCause().getCause() instanceof IOException && t.getCause().getCause().getMessage().contains("during transformation. Error code 3")) {
                ServerLogger.ROOT_LOGGER.tracef(t, "Ignoring transformation error and using original archive %s", name);
                return DeploymentHandlerUtils.getInputStream(context, contentItemNode);
            }
            throw t;
        }
    }
}

