/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.activation;

import com.sun.corba.se.impl.activation.CommandHandler;
import com.sun.corba.se.impl.activation.ServerTool;
import com.sun.corba.se.impl.orbutil.CorbaResourceUtil;
import com.sun.corba.se.spi.activation.Activator;
import com.sun.corba.se.spi.activation.ActivatorHelper;
import com.sun.corba.se.spi.activation.Repository;
import com.sun.corba.se.spi.activation.RepositoryHelper;
import com.sun.corba.se.spi.activation.ServerHeldDown;
import com.sun.corba.se.spi.activation.ServerNotRegistered;
import java.io.PrintStream;
import org.omg.CORBA.ORB;

class UnRegisterServer
implements CommandHandler {
    static final int illegalServerId = -1;

    UnRegisterServer() {
    }

    @Override
    public String getCommandName() {
        return "unregister";
    }

    @Override
    public void printCommandHelp(PrintStream out, boolean helpType) {
        if (!helpType) {
            out.println(CorbaResourceUtil.getText("servertool.unregister"));
        } else {
            out.println(CorbaResourceUtil.getText("servertool.unregister1"));
        }
    }

    @Override
    public boolean processCommand(String[] cmdArgs, ORB orb, PrintStream out) {
        int serverId = -1;
        try {
            if (cmdArgs.length == 2) {
                if (cmdArgs[0].equals("-serverid")) {
                    serverId = Integer.valueOf(cmdArgs[1]);
                } else if (cmdArgs[0].equals("-applicationName")) {
                    serverId = ServerTool.getServerIdForAlias(orb, cmdArgs[1]);
                }
            }
            if (serverId == -1) {
                return true;
            }
            try {
                Activator activator = ActivatorHelper.narrow(orb.resolve_initial_references("ServerActivator"));
                activator.uninstall(serverId);
            }
            catch (ServerHeldDown activator) {
                // empty catch block
            }
            Repository repository = RepositoryHelper.narrow(orb.resolve_initial_references("ServerRepository"));
            repository.unregisterServer(serverId);
            out.println(CorbaResourceUtil.getText("servertool.unregister2"));
        }
        catch (ServerNotRegistered ex) {
            out.println(CorbaResourceUtil.getText("servertool.nosuchserver"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return false;
    }
}

