/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.parser.servlet;

import java.util.HashMap;

public enum Version {
    SERVLET_2_2("2.2"),
    SERVLET_2_3("2.3"),
    SERVLET_2_4("2.4"),
    SERVLET_2_5("2.5"),
    SERVLET_3_0("3.0"),
    SERVLET_3_1("3.1"),
    SERVLET_4_0("4.0"),
    SERVLET_5_0("5.0");

    private static final HashMap<String, Version> systemIDmap;
    private static final HashMap<String, Version> publicIDmap;
    private final String version;

    private Version(String version) {
        this.version = version;
    }

    public static Version fromSystemID(String systemID) {
        return systemIDmap.get(systemID);
    }

    public static Version fromPublicID(String publicID) {
        return publicIDmap.get(publicID);
    }

    public String versionString() {
        return this.version;
    }

    static {
        systemIDmap = new HashMap();
        systemIDmap.put("http://java.sun.com/j2ee/dtds/web-app_2_2.dtd", SERVLET_2_2);
        systemIDmap.put("http://java.sun.com/dtd/web-app_2_3.dtd", SERVLET_2_3);
        systemIDmap.put("http://java.sun.com/xml/ns/j2ee/web-app_2_4.xsd", SERVLET_2_4);
        systemIDmap.put("http://java.sun.com/xml/ns/javaee/web-app_2_5.xsd", SERVLET_2_5);
        systemIDmap.put("http://java.sun.com/xml/ns/javaee/web-app_3_0.xsd", SERVLET_3_0);
        systemIDmap.put("http://xmlns.jcp.org/xml/ns/javaee/web-app_3_1.xsd", SERVLET_3_1);
        systemIDmap.put("http://xmlns.jcp.org/xml/ns/javaee/web-app_4_0.xsd", SERVLET_4_0);
        systemIDmap.put("https://jakarta.ee/xml/ns/jakartaee/web-app_5_0.xsd", SERVLET_5_0);
        publicIDmap = new HashMap();
        publicIDmap.put("-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN", SERVLET_2_2);
        publicIDmap.put("-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN", SERVLET_2_3);
    }
}

