/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.security.doseta;

import java.io.IOException;
import javax.annotation.Priority;
import javax.ws.rs.ConstrainedTo;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.FeatureContext;
import org.jboss.resteasy.annotations.security.doseta.Signed;
import org.jboss.resteasy.core.ResteasyContext;
import org.jboss.resteasy.security.doseta.AbstractDigitalSigningHeaderDecorator;
import org.jboss.resteasy.security.doseta.DKIMSignature;
import org.jboss.resteasy.security.doseta.KeyRepository;

@ConstrainedTo(value=RuntimeType.SERVER)
public class ServerDigitalSigningHeaderDecoratorFeature
implements DynamicFeature {
    public void configure(ResourceInfo resourceInfo, FeatureContext configurable) {
        Signed signed = resourceInfo.getResourceMethod().getAnnotation(Signed.class);
        if (signed == null) {
            signed = resourceInfo.getResourceClass().getAnnotation(Signed.class);
        }
        if (signed == null) {
            return;
        }
        configurable.register((Object)new DigitalSigningHeaderDecorator(signed));
    }

    @Priority(value=3000)
    public static class DigitalSigningHeaderDecorator
    extends AbstractDigitalSigningHeaderDecorator
    implements ContainerResponseFilter {
        public DigitalSigningHeaderDecorator(Signed signed) {
            this.signed = signed;
        }

        public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
            KeyRepository repository = (KeyRepository)ResteasyContext.getContextData(KeyRepository.class);
            DKIMSignature header = this.createHeader(repository);
            responseContext.getHeaders().add((Object)"DKIM-Signature", (Object)header);
        }
    }
}

