/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.infinispan.marshalling;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.infinispan.commons.io.ByteBufferImpl;
import org.wildfly.clustering.marshalling.Externalizer;
import org.wildfly.clustering.marshalling.spi.IndexSerializer;

public enum ByteBufferExternalizer implements Externalizer<ByteBufferImpl>
{
    INSTANCE;


    public void writeObject(ObjectOutput output, ByteBufferImpl buffer) throws IOException {
        IndexSerializer.VARIABLE.writeInt((DataOutput)output, buffer != null ? buffer.getLength() : 0);
        if (buffer != null) {
            output.write(buffer.getBuf(), buffer.getOffset(), buffer.getLength());
        }
    }

    public ByteBufferImpl readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        int length = IndexSerializer.VARIABLE.readInt((DataInput)input);
        if (length == 0) {
            return null;
        }
        byte[] bytes = new byte[length];
        input.readFully(bytes);
        return ByteBufferImpl.create((byte[])bytes);
    }

    public Class<ByteBufferImpl> getTargetClass() {
        return ByteBufferImpl.class;
    }
}

