/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.management.impl.view.predicate;

import java.util.Collection;
import java.util.function.Predicate;

public class ActiveMQFilterPredicate<T>
implements Predicate<T> {
    protected String field;
    protected String value;
    protected Operation operation;

    public static boolean contains(String field, String value) {
        return field.contains(value);
    }

    @Override
    public boolean test(T input) {
        return true;
    }

    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        this.field = field;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        if (operation != null && !operation.equals("")) {
            this.operation = Operation.valueOf(operation);
        }
    }

    public boolean matches(Object field) {
        if (this.operation != null) {
            switch (this.operation) {
                case EQUALS: {
                    return this.equals(field, this.value);
                }
                case CONTAINS: {
                    return this.contains(field, this.value);
                }
                case GREATER_THAN: {
                    return false;
                }
                case LESS_THAN: {
                    return false;
                }
            }
        }
        return true;
    }

    public boolean matchAny(Collection objects) {
        for (Object o : objects) {
            if (!this.matches(o)) continue;
            return true;
        }
        return false;
    }

    public boolean matches(long field) {
        if (this.operation != null) {
            long longValue;
            try {
                longValue = Long.parseLong(this.value);
            }
            catch (NumberFormatException ex) {
                return false;
            }
            switch (this.operation) {
                case EQUALS: {
                    return field == longValue;
                }
                case CONTAINS: {
                    return false;
                }
                case LESS_THAN: {
                    return field < longValue;
                }
                case GREATER_THAN: {
                    return field > longValue;
                }
            }
        }
        return true;
    }

    public boolean matches(int field) {
        if (this.operation != null) {
            int intValue;
            try {
                intValue = Integer.parseInt(this.value);
            }
            catch (NumberFormatException ex) {
                return false;
            }
            switch (this.operation) {
                case EQUALS: {
                    return field == intValue;
                }
                case CONTAINS: {
                    return false;
                }
                case LESS_THAN: {
                    return field < intValue;
                }
                case GREATER_THAN: {
                    return field > intValue;
                }
            }
        }
        return true;
    }

    public boolean matches(float field) {
        if (this.operation != null) {
            float floatValue;
            try {
                floatValue = Float.parseFloat(this.value);
            }
            catch (NumberFormatException ex) {
                return false;
            }
            switch (this.operation) {
                case EQUALS: {
                    return field == floatValue;
                }
                case CONTAINS: {
                    return false;
                }
                case LESS_THAN: {
                    return field < floatValue;
                }
                case GREATER_THAN: {
                    return field > floatValue;
                }
            }
        }
        return true;
    }

    private boolean equals(Object field, Object value) {
        if (field == null) {
            return value == null || value.equals("");
        }
        return field.toString().equals(value);
    }

    private boolean contains(Object field, Object value) {
        if (field == null) {
            return value == null || value.equals("");
        }
        return field.toString().contains(value.toString());
    }

    static enum Operation {
        CONTAINS,
        EQUALS,
        GREATER_THAN,
        LESS_THAN;

    }
}

