/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.metadata;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.patching.DirectoryStructure;
import org.jboss.as.patching.installation.AddOn;
import org.jboss.as.patching.installation.Identity;
import org.jboss.as.patching.installation.InstalledIdentity;
import org.jboss.as.patching.installation.InstalledIdentityImpl;
import org.jboss.as.patching.installation.Layer;
import org.jboss.as.patching.installation.LayerInfo;
import org.jboss.as.patching.installation.PatchableTarget;
import org.jboss.as.patching.metadata.Patch;
import org.jboss.as.patching.metadata.PatchBuilder;
import org.jboss.as.patching.metadata.PatchImpl;
import org.jboss.as.patching.metadata.PatchMetadataResolver;
import org.jboss.as.patching.metadata.PatchXml;
import org.jboss.as.patching.metadata.PatchXmlUtils;
import org.jboss.as.patching.metadata.RollbackPatch;
import org.jboss.as.patching.runner.PatchUtils;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

class RollbackPatchXml_1_0
extends PatchXmlUtils
implements XMLStreamConstants,
XMLElementReader<PatchXml.Result<PatchMetadataResolver>>,
XMLElementWriter<RollbackPatch> {
    RollbackPatchXml_1_0() {
    }

    public void readElement(XMLExtendedStreamReader reader, PatchXml.Result<PatchMetadataResolver> factory) throws XMLStreamException {
        RollbackPatchBuilder builder = new RollbackPatchBuilder();
        this.doReadElement(reader, builder, factory.getOriginalIdentity());
        factory.setResult(builder);
    }

    @Override
    protected void handleRootElement(String localName, XMLExtendedStreamReader reader, PatchBuilder patch, InstalledIdentity originalIdentity) throws XMLStreamException {
        RollbackPatchBuilder builder = (RollbackPatchBuilder)patch;
        Element element = Element.forName(localName);
        if (element != Element.INSTALLATION) {
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        InstalledIdentity identity = RollbackPatchXml_1_0.processInstallation(reader, originalIdentity);
        builder.setIdentity(identity);
    }

    public void writeContent(XMLExtendedStreamWriter writer, RollbackPatch rollbackPatch) throws XMLStreamException {
        writer.writeStartDocument();
        writer.writeStartElement(Element.PATCH.name);
        writer.writeDefaultNamespace(PatchXml.Namespace.ROLLBACK_1_2.getNamespace());
        RollbackPatchXml_1_0.writePatch(writer, rollbackPatch);
        RollbackPatchXml_1_0.writeInstallation(writer, rollbackPatch.getIdentityState());
        writer.writeEndElement();
        writer.writeEndDocument();
    }

    static InstalledIdentity processInstallation(XMLExtendedStreamReader reader, InstalledIdentity originalIdentity) throws XMLStreamException {
        LayerInfo identity = null;
        LinkedHashMap<String, LayerInfo> layers = new LinkedHashMap<String, LayerInfo>();
        LinkedHashMap<String, LayerInfo> addOns = new LinkedHashMap<String, LayerInfo>();
        block5: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case IDENTITY: {
                    identity = RollbackPatchXml_1_0.parseTargetInfo(reader, originalIdentity, element);
                    continue block5;
                }
                case LAYER: {
                    LayerInfo info = RollbackPatchXml_1_0.parseTargetInfo(reader, originalIdentity, element);
                    layers.put(info.getName(), info);
                    continue block5;
                }
                case ADD_ON: {
                    LayerInfo info = RollbackPatchXml_1_0.parseTargetInfo(reader, originalIdentity, element);
                    addOns.put(info.getName(), info);
                    continue block5;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        DirectoryStructure structure = identity.getDirectoryStructure();
        WrappedIdentity installation = new WrappedIdentity(identity, structure);
        for (Map.Entry entry : layers.entrySet()) {
            installation.putLayer((String)entry.getKey(), (Layer)entry.getValue());
        }
        for (Map.Entry entry : addOns.entrySet()) {
            installation.putAddOn((String)entry.getKey(), (AddOn)entry.getValue());
        }
        return installation;
    }

    static LayerInfo parseTargetInfo(XMLExtendedStreamReader reader, InstalledIdentity originalIdentity, Element target) throws XMLStreamException {
        DirectoryStructure dirStructure;
        String name = null;
        Properties properties = new Properties();
        int count = reader.getAttributeCount();
        block9: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block9;
                }
                case PATCHES: {
                    properties.put("patches", value);
                    continue block9;
                }
                case RELEASE_ID: {
                    properties.put("cumulative-patch-id", value);
                    continue block9;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        if (originalIdentity != null) {
            switch (target) {
                case LAYER: {
                    dirStructure = originalIdentity.getLayer(name).getDirectoryStructure();
                    break;
                }
                case ADD_ON: {
                    dirStructure = originalIdentity.getAddOn(name).getDirectoryStructure();
                    break;
                }
                default: {
                    dirStructure = originalIdentity.getIdentity().getDirectoryStructure();
                    break;
                }
            }
        } else {
            dirStructure = null;
        }
        PatchableTarget.TargetInfo info = LayerInfo.loadTargetInfo(properties, dirStructure);
        return new LayerInfo(name, info, dirStructure);
    }

    static void writeInstallation(XMLExtendedStreamWriter writer, InstalledIdentity identity) throws XMLStreamException {
        writer.writeStartElement(Element.INSTALLATION.name);
        RollbackPatchXml_1_0.writeTargetInfo(writer, Element.IDENTITY, identity.getIdentity());
        for (Layer layer : identity.getLayers()) {
            RollbackPatchXml_1_0.writeTargetInfo(writer, Element.LAYER, layer);
        }
        for (AddOn addOn : identity.getAddOns()) {
            RollbackPatchXml_1_0.writeTargetInfo(writer, Element.ADD_ON, addOn);
        }
        writer.writeEndElement();
    }

    static void writeTargetInfo(XMLExtendedStreamWriter writer, Element element, PatchableTarget target) throws XMLStreamException {
        try {
            PatchableTarget.TargetInfo info = target.loadTargetInfo();
            writer.writeEmptyElement(element.name);
            writer.writeAttribute(Attribute.NAME.name, target.getName());
            writer.writeAttribute(Attribute.RELEASE_ID.name, info.getCumulativePatchID());
            if (!info.getPatchIDs().isEmpty()) {
                writer.writeAttribute(Attribute.PATCHES.name, PatchUtils.asString(info.getPatchIDs()));
            }
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }

    static class RollbackPatchBuilder
    extends PatchBuilder {
        protected InstalledIdentity identity;

        RollbackPatchBuilder() {
        }

        void setIdentity(InstalledIdentity identity) {
            this.identity = identity;
        }

        @Override
        public Patch build() {
            Patch patch = super.build();
            return new PatchImpl.RollbackPatchImpl(patch, this.identity);
        }
    }

    static class WrappedIdentity
    extends InstalledIdentityImpl {
        final PatchableTarget identity;

        WrappedIdentity(final PatchableTarget identity, DirectoryStructure structure) {
            super(new Identity(){

                @Override
                public String getVersion() {
                    return null;
                }

                @Override
                public String getName() {
                    return identity.getName();
                }

                @Override
                public PatchableTarget.TargetInfo loadTargetInfo() throws IOException {
                    return identity.loadTargetInfo();
                }

                @Override
                public DirectoryStructure getDirectoryStructure() {
                    return identity.getDirectoryStructure();
                }
            }, Collections.emptyList(), structure == null ? null : structure.getInstalledImage());
            this.identity = identity;
        }

        @Override
        protected Layer putLayer(String name, Layer layer) {
            return super.putLayer(name, layer);
        }

        @Override
        protected AddOn putAddOn(String name, AddOn addOn) {
            return super.putAddOn(name, addOn);
        }
    }

    static enum Attribute {
        NAME("name"),
        PATCHES("patches"),
        RELEASE_ID("release-id"),
        UNKNOWN(null);

        private final String name;
        static Map<String, Attribute> attributes;

        private Attribute(String name) {
            this.name = name;
        }

        static Attribute forName(String name) {
            Attribute attribute = attributes.get(name);
            return attribute == null ? UNKNOWN : attribute;
        }

        static {
            attributes = new HashMap<String, Attribute>();
            for (Attribute attribute : Attribute.values()) {
                if (attribute == UNKNOWN) continue;
                attributes.put(attribute.name, attribute);
            }
        }
    }

    static enum Element {
        ADD_ON("add-on"),
        IDENTITY("identity"),
        INSTALLATION("installation"),
        LAYER("layer"),
        PATCH("patch"),
        UNKNOWN(null);

        public final String name;
        static Map<String, Element> elements;

        private Element(String name) {
            this.name = name;
        }

        static Element forName(String name) {
            Element element = elements.get(name);
            return element == null ? UNKNOWN : element;
        }

        static {
            elements = new HashMap<String, Element>();
            for (Element element : Element.values()) {
                if (element == UNKNOWN) continue;
                elements.put(element.name, element);
            }
        }
    }
}

