/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server;

import java.util.Arrays;
import java.util.Collections;
import java.util.function.Function;
import org.jboss.as.clustering.controller.CapabilityServiceConfigurator;
import org.jboss.as.clustering.controller.IdentityCapabilityServiceConfigurator;
import org.jboss.as.clustering.controller.UnaryServiceNameFactory;
import org.jboss.as.clustering.naming.BinderServiceConfigurator;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.deployment.JndiName;
import org.jboss.msc.service.ServiceName;
import org.wildfly.clustering.service.Requirement;
import org.wildfly.clustering.service.ServiceNameRegistry;
import org.wildfly.clustering.spi.ClusteringRequirement;
import org.wildfly.clustering.spi.IdentityGroupServiceConfiguratorProvider;

public class IdentityGroupRequirementServiceConfiguratorProvider
implements IdentityGroupServiceConfiguratorProvider {
    private final ClusteringRequirement requirement;
    private final Function<String, JndiName> jndiNameFactory;

    protected IdentityGroupRequirementServiceConfiguratorProvider(ClusteringRequirement requirement) {
        this(requirement, null);
    }

    protected IdentityGroupRequirementServiceConfiguratorProvider(ClusteringRequirement requirement, Function<String, JndiName> jndiNameFactory) {
        this.requirement = requirement;
        this.jndiNameFactory = jndiNameFactory;
    }

    public Iterable<CapabilityServiceConfigurator> getServiceConfigurators(ServiceNameRegistry<ClusteringRequirement> registry, String group, String targetGroup) {
        ServiceName name = registry.getServiceName((Requirement)this.requirement);
        if (name == null) {
            return Collections.emptySet();
        }
        IdentityCapabilityServiceConfigurator configurator = new IdentityCapabilityServiceConfigurator(name, (UnaryServiceNameFactory)this.requirement, targetGroup);
        if (this.jndiNameFactory == null || "default".equals(targetGroup)) {
            return Collections.singleton(configurator);
        }
        ContextNames.BindInfo binding = ContextNames.bindInfoFor((String)this.jndiNameFactory.apply(group).getAbsoluteName());
        BinderServiceConfigurator binderConfigurator = new BinderServiceConfigurator(binding, configurator.getServiceName());
        return Arrays.asList(configurator, binderConfigurator);
    }

    public String toString() {
        return this.getClass().getName();
    }
}

