/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.impl.connectionfactory;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.infinispan.commons.util.Util;
import org.infinispan.persistence.jdbc.configuration.ConnectionFactoryConfiguration;
import org.infinispan.persistence.jdbc.configuration.SimpleConnectionFactoryConfiguration;
import org.infinispan.persistence.jdbc.connectionfactory.ConnectionFactory;
import org.infinispan.persistence.jdbc.logging.Log;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.util.logging.LogFactory;

public class SimpleConnectionFactory
extends ConnectionFactory {
    private static final Log log = (Log)LogFactory.getLog(SimpleConnectionFactory.class, Log.class);
    private String connectionUrl;
    private String userName;
    private String password;
    private volatile int connectionCount = 0;

    @Override
    public void start(ConnectionFactoryConfiguration config, ClassLoader classLoader) throws PersistenceException {
        if (!(config instanceof SimpleConnectionFactoryConfiguration)) {
            throw new PersistenceException("ConnectionFactoryConfiguration has to be an instance of SimpleConnectionFactoryConfiguration.");
        }
        SimpleConnectionFactoryConfiguration factoryConfiguration = (SimpleConnectionFactoryConfiguration)config;
        this.loadDriver(factoryConfiguration.driverClass(), classLoader);
        this.connectionUrl = factoryConfiguration.connectionUrl();
        this.userName = factoryConfiguration.username();
        this.password = factoryConfiguration.password();
        if (log.isTraceEnabled()) {
            log.tracef("Starting connection %s", this);
        }
    }

    @Override
    public void stop() {
    }

    @Override
    public Connection getConnection() throws PersistenceException {
        try {
            Connection connection = DriverManager.getConnection(this.connectionUrl, this.userName, this.password);
            if (connection == null) {
                throw new PersistenceException("Received null connection from the DriverManager!");
            }
            ++this.connectionCount;
            return connection;
        }
        catch (SQLException e) {
            throw new PersistenceException("Could not obtain a new connection", (Throwable)e);
        }
    }

    @Override
    public void releaseConnection(Connection conn) {
        try {
            if (conn != null) {
                conn.close();
                --this.connectionCount;
            }
        }
        catch (SQLException e) {
            Log.PERSISTENCE.failureClosingConnection(e);
        }
    }

    private void loadDriver(String driverClass, ClassLoader classLoader) throws PersistenceException {
        if (log.isTraceEnabled()) {
            log.tracef("Attempting to load driver %s", driverClass);
        }
        Util.getInstance((String)driverClass, (ClassLoader)classLoader);
    }

    public String getConnectionUrl() {
        return this.connectionUrl;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public int getConnectionCount() {
        return this.connectionCount;
    }

    public String toString() {
        return "SimpleConnectionFactory{connectionUrl='" + this.connectionUrl + '\'' + ", userName='" + this.userName + '\'' + "} " + super.toString();
    }
}

