/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.kafka.impl;

import io.smallrye.common.annotation.Identifier;
import io.smallrye.reactive.messaging.i18n.ProviderLogging;
import io.smallrye.reactive.messaging.kafka.KafkaConnectorIncomingConfiguration;
import io.smallrye.reactive.messaging.kafka.KafkaConsumerRebalanceListener;
import io.smallrye.reactive.messaging.kafka.commit.KafkaCommitHandler;
import io.smallrye.reactive.messaging.kafka.i18n.KafkaExceptions;
import io.smallrye.reactive.messaging.kafka.i18n.KafkaLogging;
import io.smallrye.reactive.messaging.kafka.impl.ReactiveKafkaConsumer;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Optional;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.literal.NamedLiteral;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.common.TopicPartition;

public class RebalanceListeners {
    static ConsumerRebalanceListener createRebalanceListener(final ReactiveKafkaConsumer<?, ?> reactiveKafkaConsumer, KafkaConnectorIncomingConfiguration config, final String consumerGroup, Instance<KafkaConsumerRebalanceListener> instances, final KafkaCommitHandler commitHandler) {
        Optional<KafkaConsumerRebalanceListener> rebalanceListener = RebalanceListeners.findMatchingListener(config, consumerGroup, instances);
        if (rebalanceListener.isPresent()) {
            final KafkaConsumerRebalanceListener listener = rebalanceListener.get();
            return new ConsumerRebalanceListener(){

                public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
                    KafkaLogging.log.executingConsumerRevokedRebalanceListener(consumerGroup);
                    try {
                        reactiveKafkaConsumer.removeFromQueueRecordsFromTopicPartitions(partitions);
                        commitHandler.partitionsRevoked(partitions);
                        listener.onPartitionsRevoked(reactiveKafkaConsumer.unwrap(), partitions);
                        KafkaLogging.log.executedConsumerRevokedRebalanceListener(consumerGroup);
                    }
                    catch (RuntimeException e) {
                        KafkaLogging.log.unableToExecuteConsumerRevokedRebalanceListener(consumerGroup, e);
                        throw e;
                    }
                }

                public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
                    try {
                        if (reactiveKafkaConsumer.isPaused()) {
                            reactiveKafkaConsumer.unwrap().pause(partitions);
                        }
                        commitHandler.partitionsAssigned(partitions);
                        listener.onPartitionsAssigned(reactiveKafkaConsumer.unwrap(), partitions);
                        KafkaLogging.log.executedConsumerAssignedRebalanceListener(consumerGroup);
                    }
                    catch (RuntimeException e) {
                        KafkaLogging.log.reEnablingConsumerForGroup(consumerGroup);
                        throw e;
                    }
                }
            };
        }
        return new ConsumerRebalanceListener(){

            public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
                reactiveKafkaConsumer.removeFromQueueRecordsFromTopicPartitions(partitions);
                commitHandler.partitionsRevoked(partitions);
            }

            public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
                if (reactiveKafkaConsumer.isPaused()) {
                    reactiveKafkaConsumer.unwrap().pause(partitions);
                }
                commitHandler.partitionsAssigned(partitions);
            }
        };
    }

    private static Optional<KafkaConsumerRebalanceListener> findMatchingListener(KafkaConnectorIncomingConfiguration config, String consumerGroup, Instance<KafkaConsumerRebalanceListener> instances) {
        return config.getConsumerRebalanceListenerName().map(name -> {
            KafkaLogging.log.loadingConsumerRebalanceListenerFromConfiguredName((String)name);
            Instance matching = instances.select(new Annotation[]{Identifier.Literal.of((String)name)});
            if (matching.isUnsatisfied() && !(matching = instances.select(new Annotation[]{NamedLiteral.of((String)name)})).isUnsatisfied()) {
                ProviderLogging.log.deprecatedNamed();
            }
            if (matching.isUnsatisfied()) {
                throw KafkaExceptions.ex.unableToFindRebalanceListener((String)name, config.getChannel());
            }
            if (matching.stream().count() > 1L) {
                throw KafkaExceptions.ex.unableToFindRebalanceListener((String)name, config.getChannel(), (int)matching.stream().count());
            }
            if (matching.stream().count() == 1L) {
                return Optional.of((KafkaConsumerRebalanceListener)matching.get());
            }
            return Optional.empty();
        }).orElseGet(() -> {
            Instance matching = instances.select(new Annotation[]{Identifier.Literal.of((String)consumerGroup)});
            if (matching.isUnsatisfied() && !(matching = instances.select(new Annotation[]{NamedLiteral.of((String)consumerGroup)})).isUnsatisfied()) {
                ProviderLogging.log.deprecatedNamed();
            }
            if (!matching.isUnsatisfied()) {
                KafkaLogging.log.loadingConsumerRebalanceListenerFromGroupId(consumerGroup);
                return Optional.of((KafkaConsumerRebalanceListener)matching.get());
            }
            return Optional.empty();
        });
    }
}

