/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.webapp;

import javax.faces.application.Application;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.validator.Validator;
import javax.faces.webapp.UIComponentTag;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;

public class ValidatorTag
extends TagSupport {
    private static final long serialVersionUID = 8794036166323016663L;
    private String _validatorId;
    private String _binding;

    public void setValidatorId(String validatorId) {
        this._validatorId = validatorId;
    }

    public int doStartTag() throws JspException {
        UIComponentTag componentTag = UIComponentTag.getParentUIComponentTag(this.pageContext);
        if (componentTag == null) {
            throw new JspException("no parent UIComponentTag found");
        }
        if (!componentTag.getCreated()) {
            return 0;
        }
        Validator validator = this.createValidator();
        UIComponent component = componentTag.getComponentInstance();
        if (component == null) {
            throw new JspException("parent UIComponentTag has no UIComponent");
        }
        if (!(component instanceof EditableValueHolder)) {
            throw new JspException("UIComponent is no ValueHolder");
        }
        ((EditableValueHolder)((Object)component)).addValidator(validator);
        return 0;
    }

    public void release() {
        super.release();
        this._validatorId = null;
        this._binding = null;
    }

    protected Validator createValidator() throws JspException {
        Validator validator;
        ValueBinding vb;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Application application = facesContext.getApplication();
        if (this._binding != null && (vb = application.createValueBinding(this._binding)) != null && (validator = (Validator)vb.getValue(facesContext)) != null) {
            return validator;
        }
        if (UIComponentTag.isValueReference(this._validatorId)) {
            vb = facesContext.getApplication().createValueBinding(this._validatorId);
            return application.createValidator((String)vb.getValue(facesContext));
        }
        return application.createValidator(this._validatorId);
    }

    public void setBinding(String binding) throws JspException {
        if (binding != null && !UIComponentTag.isValueReference(binding)) {
            throw new IllegalArgumentException("not a valid binding: " + binding);
        }
        this._binding = binding;
    }
}

