/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.serializer;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Objects;
import java.util.Optional;
import javax.json.bind.serializer.JsonbSerializer;
import javax.json.bind.serializer.SerializationContext;
import javax.json.stream.JsonGenerator;
import org.eclipse.yasson.internal.Marshaller;
import org.eclipse.yasson.internal.ReflectionUtils;
import org.eclipse.yasson.internal.model.ClassModel;
import org.eclipse.yasson.internal.model.customization.ClassCustomizationBuilder;
import org.eclipse.yasson.internal.model.customization.ContainerCustomization;
import org.eclipse.yasson.internal.serializer.AbstractItem;
import org.eclipse.yasson.internal.serializer.CurrentItem;
import org.eclipse.yasson.internal.serializer.DefaultSerializers;
import org.eclipse.yasson.internal.serializer.SerializerBuilder;

public abstract class AbstractContainerSerializer<T>
extends AbstractItem<T>
implements JsonbSerializer<T> {
    private JsonbSerializer<?> valueSerializer;
    private Class<?> valueClass;

    protected AbstractContainerSerializer(SerializerBuilder builder) {
        super(builder);
    }

    public AbstractContainerSerializer(CurrentItem<?> wrapper, Type runtimeType, ClassModel classModel) {
        super(wrapper, runtimeType, classModel);
    }

    protected void beforeSerialize(T obj) {
    }

    protected abstract void writeStart(JsonGenerator var1);

    protected abstract void writeStart(String var1, JsonGenerator var2);

    protected void writeEnd(JsonGenerator generator) {
        generator.writeEnd();
    }

    protected abstract void serializeInternal(T var1, JsonGenerator var2, SerializationContext var3);

    public final void serialize(T obj, JsonGenerator generator, SerializationContext ctx) {
        this.beforeSerialize(obj);
        this.writeStart(generator);
        this.serializeInternal(obj, generator, ctx);
        this.writeEnd(generator);
    }

    protected <X> void serializerCaptor(JsonbSerializer<?> serializer, X object, JsonGenerator generator, SerializationContext ctx) {
        serializer.serialize(object, generator, ctx);
    }

    protected JsonbSerializer<?> getValueSerializer(Class<?> valueClass) {
        if (this.valueSerializer != null && valueClass == this.valueClass) {
            return this.valueSerializer;
        }
        return null;
    }

    protected void addValueSerializer(JsonbSerializer<?> valueSerializer, Class<?> valueClass) {
        Objects.requireNonNull(valueSerializer);
        Objects.requireNonNull(valueClass);
        this.valueSerializer = valueSerializer;
        this.valueClass = valueClass;
    }

    protected void serializeItem(Object item, JsonGenerator generator, SerializationContext ctx) {
        if (item == null) {
            generator.writeNull();
            return;
        }
        Class<?> itemClass = item.getClass();
        JsonbSerializer<?> serializer = this.getValueSerializer(itemClass);
        if (serializer == null) {
            Type instanceValueType = this.getValueType(this.getRuntimeType());
            instanceValueType = instanceValueType.equals(Object.class) ? itemClass : instanceValueType;
            SerializerBuilder builder = new SerializerBuilder(((Marshaller)ctx).getJsonbContext());
            builder.withObjectClass(itemClass);
            builder.withWrapper(this);
            builder.withType(instanceValueType);
            if (!DefaultSerializers.getInstance().isKnownType(itemClass)) {
                ClassModel classModel = ((Marshaller)ctx).getJsonbContext().getMappingContext().getOrCreateClassModel(itemClass);
                builder.withCustomization(new ContainerCustomization(classModel.getClassCustomization()));
            } else {
                builder.withCustomization(new ContainerCustomization(new ClassCustomizationBuilder()));
            }
            serializer = builder.build();
            this.addValueSerializer(serializer, itemClass);
        }
        this.serializerCaptor(serializer, item, generator, ctx);
    }

    protected Type getValueType(Type valueType) {
        if (valueType instanceof ParameterizedType) {
            Optional<Type> runtimeTypeOptional = ReflectionUtils.resolveOptionalType(this, ((ParameterizedType)valueType).getActualTypeArguments()[0]);
            return (Type)((Object)runtimeTypeOptional.orElse((Type)((Object)Object.class)));
        }
        return Object.class;
    }
}

