/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.infinispan;

import java.util.function.Consumer;
import org.infinispan.Cache;
import org.infinispan.remoting.transport.Address;
import org.jboss.as.clustering.controller.CapabilityServiceConfigurator;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.ejb.BeanManagerFactoryServiceConfiguratorConfiguration;
import org.wildfly.clustering.ejb.BeanPassivationConfiguration;
import org.wildfly.clustering.ejb.StatefulBeanConfiguration;
import org.wildfly.clustering.ejb.infinispan.InfinispanBeanManagerFactory;
import org.wildfly.clustering.ejb.infinispan.InfinispanBeanManagerFactoryConfiguration;
import org.wildfly.clustering.ejb.infinispan.InfinispanBeanManagerFactoryServiceConfiguratorFactory;
import org.wildfly.clustering.infinispan.spi.InfinispanCacheRequirement;
import org.wildfly.clustering.infinispan.spi.InfinispanRequirement;
import org.wildfly.clustering.infinispan.spi.affinity.KeyAffinityServiceFactory;
import org.wildfly.clustering.marshalling.jboss.MarshallingConfigurationRepository;
import org.wildfly.clustering.service.CompositeDependency;
import org.wildfly.clustering.service.Dependency;
import org.wildfly.clustering.service.ServiceConfigurator;
import org.wildfly.clustering.service.ServiceSupplierDependency;
import org.wildfly.clustering.service.SimpleServiceNameProvider;
import org.wildfly.clustering.service.SupplierDependency;
import org.wildfly.clustering.spi.ClusteringCacheRequirement;
import org.wildfly.clustering.spi.ClusteringRequirement;
import org.wildfly.clustering.spi.dispatcher.CommandDispatcherFactory;
import org.wildfly.clustering.spi.group.Group;

public class InfinispanBeanManagerFactoryServiceConfigurator<I, T>
extends SimpleServiceNameProvider
implements CapabilityServiceConfigurator,
InfinispanBeanManagerFactoryConfiguration {
    private final String name;
    private final StatefulBeanConfiguration beanConfiguration;
    private final BeanManagerFactoryServiceConfiguratorConfiguration configuration;
    private final SupplierDependency<MarshallingConfigurationRepository> repository;
    private volatile SupplierDependency<Cache<?, ?>> cache;
    private volatile SupplierDependency<KeyAffinityServiceFactory> affinityFactory;
    private volatile SupplierDependency<Group<Address>> group;
    private volatile SupplierDependency<CommandDispatcherFactory> dispatcherFactory;

    public InfinispanBeanManagerFactoryServiceConfigurator(String name, StatefulBeanConfiguration beanConfiguration, BeanManagerFactoryServiceConfiguratorConfiguration configuration) {
        super(beanConfiguration.getDeploymentUnitServiceName().append(new String[]{beanConfiguration.getName()}).append(new String[]{"bean-manager"}));
        this.name = name;
        this.beanConfiguration = beanConfiguration;
        this.configuration = configuration;
        ServiceName deploymentUnitServiceName = beanConfiguration.getDeploymentUnitServiceName();
        this.repository = new ServiceSupplierDependency(deploymentUnitServiceName.append(new String[]{"marshalling"}));
    }

    public ServiceConfigurator configure(CapabilityServiceSupport support) {
        String containerName = this.configuration.getContainerName();
        ServiceName deploymentUnitServiceName = this.beanConfiguration.getDeploymentUnitServiceName();
        String cacheName = InfinispanBeanManagerFactoryServiceConfiguratorFactory.getCacheName(deploymentUnitServiceName, this.name);
        this.cache = new ServiceSupplierDependency(InfinispanCacheRequirement.CACHE.getServiceName(support, containerName, cacheName));
        this.affinityFactory = new ServiceSupplierDependency(InfinispanRequirement.KEY_AFFINITY_FACTORY.getServiceName(support, containerName));
        this.dispatcherFactory = new ServiceSupplierDependency(ClusteringRequirement.COMMAND_DISPATCHER_FACTORY.getServiceName(support, containerName));
        this.group = new ServiceSupplierDependency(ClusteringCacheRequirement.GROUP.getServiceName(support, containerName, cacheName));
        return this;
    }

    public ServiceBuilder<?> build(ServiceTarget target) {
        ServiceBuilder builder = target.addService(this.getServiceName());
        new CompositeDependency(new Dependency[]{this.cache, this.affinityFactory, this.repository, this.group, this.dispatcherFactory}).register(builder);
        Consumer factory = builder.provides(new ServiceName[]{this.getServiceName()});
        Service service = Service.newInstance((Consumer)factory, new InfinispanBeanManagerFactory(this));
        return builder.setInstance(service).setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public StatefulBeanConfiguration getBeanConfiguration() {
        return this.beanConfiguration;
    }

    @Override
    public <K, V> Cache<K, V> getCache() {
        return (Cache)this.cache.get();
    }

    @Override
    public KeyAffinityServiceFactory getKeyAffinityServiceFactory() {
        return (KeyAffinityServiceFactory)this.affinityFactory.get();
    }

    @Override
    public MarshallingConfigurationRepository getMarshallingConfigurationRepository() {
        return (MarshallingConfigurationRepository)this.repository.get();
    }

    @Override
    public BeanPassivationConfiguration getPassivationConfiguration() {
        return this.configuration;
    }

    @Override
    public Group<Address> getGroup() {
        return (Group)this.group.get();
    }

    @Override
    public CommandDispatcherFactory getCommandDispatcherFactory() {
        return (CommandDispatcherFactory)this.dispatcherFactory.get();
    }
}

