/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.discovery;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.wildfly.discovery.spi.DiscoveryProvider;
import org.wildfly.extension.discovery.AggregateDiscoveryProviderDefinition;
import org.wildfly.extension.discovery.AggregateDiscoveryProviderService;
import org.wildfly.extension.discovery.DiscoveryExtension;

class AggregateDiscoveryProviderAddHandler
extends AbstractAddStepHandler {
    AggregateDiscoveryProviderAddHandler() {
        super(new AbstractAddStepHandler.Parameters().addAttribute(new AttributeDefinition[]{AggregateDiscoveryProviderDefinition.PROVIDER_NAMES}));
    }

    protected void performRuntime(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        ServiceName name = DiscoveryExtension.DISCOVERY_PROVIDER_CAPABILITY.getCapabilityServiceName(context.getCurrentAddress());
        ServiceBuilder builder = context.getCapabilityServiceTarget().addService(name);
        Consumer provider = builder.provides(new ServiceName[]{name});
        List providerNames = AggregateDiscoveryProviderDefinition.PROVIDER_NAMES.unwrap((ExpressionResolver)context, resource.getModel());
        ArrayList<Supplier<DiscoveryProvider>> providers = new ArrayList<Supplier<DiscoveryProvider>>(providerNames.size());
        for (String providerName : providerNames) {
            providers.add(builder.requires(context.getCapabilityServiceName(DiscoveryExtension.DISCOVERY_PROVIDER_CAPABILITY.getName(), DiscoveryProvider.class, new String[]{providerName})));
        }
        builder.setInstance((Service)new AggregateDiscoveryProviderService(provider, providers)).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
    }

    protected void rollbackRuntime(OperationContext context, ModelNode operation, Resource resource) {
        context.removeService(DiscoveryExtension.DISCOVERY_PROVIDER_CAPABILITY.getCapabilityServiceName(context.getCurrentAddress()));
    }
}

