/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.tag.jsf;

import com.sun.faces.facelets.tag.MetaRulesetImpl;
import com.sun.faces.facelets.tag.jsf.ComponentSupport;
import com.sun.faces.facelets.tag.jsf.CompositeComponentTagHandler;
import com.sun.faces.util.Util;
import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.io.IOException;
import java.util.List;
import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.Behavior;
import javax.faces.component.behavior.ClientBehavior;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.view.AttachedObjectHandler;
import javax.faces.view.AttachedObjectTarget;
import javax.faces.view.BehaviorHolderAttachedObjectTarget;
import javax.faces.view.facelets.BehaviorHandler;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.MetaRuleset;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagException;
import javax.faces.view.facelets.TagHandlerDelegate;

class BehaviorTagHandlerDelegateImpl
extends TagHandlerDelegate
implements AttachedObjectHandler {
    private BehaviorHandler owner;

    public BehaviorTagHandlerDelegateImpl(BehaviorHandler owner) {
        this.owner = owner;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void apply(FaceletContext ctx, UIComponent parent) throws IOException {
        if (parent == null || parent.getParent() != null) {
            return;
        }
        ComponentSupport.copyPassthroughAttributes(ctx, parent, this.owner.getTag());
        if (UIComponent.isCompositeComponent((UIComponent)parent)) {
            BeanInfo componentBeanInfo = (BeanInfo)parent.getAttributes().get("javax.faces.component.BEANINFO_KEY");
            if (null == componentBeanInfo) {
                throw new TagException(this.owner.getTag(), "Error: enclosing composite component does not have BeanInfo attribute");
            }
            BeanDescriptor componentDescriptor = componentBeanInfo.getBeanDescriptor();
            if (null == componentDescriptor) {
                throw new TagException(this.owner.getTag(), "Error: enclosing composite component BeanInfo does not have BeanDescriptor");
            }
            List targetList = (List)componentDescriptor.getValue("javax.faces.view.AttachedObjectTargets");
            if (null == targetList) {
                throw new TagException(this.owner.getTag(), "Error: enclosing composite component does not support behavior events");
            }
            String eventName = this.owner.getEventName();
            boolean supportedEvent = false;
            for (AttachedObjectTarget target : targetList) {
                if (!(target instanceof BehaviorHolderAttachedObjectTarget)) continue;
                BehaviorHolderAttachedObjectTarget behaviorTarget = (BehaviorHolderAttachedObjectTarget)target;
                if ((null == eventName || !eventName.equals(behaviorTarget.getName())) && (null != eventName || !behaviorTarget.isDefaultEvent())) continue;
                supportedEvent = true;
                break;
            }
            if (!supportedEvent) throw new TagException(this.owner.getTag(), "Error: enclosing composite component does not support event " + eventName);
            CompositeComponentTagHandler.getAttachedObjectHandlers(parent).add((AttachedObjectHandler)this.owner);
            return;
        } else {
            if (!(parent instanceof ClientBehaviorHolder)) throw new TagException(this.owner.getTag(), "Parent not an instance of ClientBehaviorHolder: " + parent);
            this.owner.applyAttachedObject(ctx.getFacesContext(), parent);
        }
    }

    public void applyAttachedObject(FacesContext context, UIComponent parent) {
        FaceletContext ctx = (FaceletContext)context.getAttributes().get(FaceletContext.FACELET_CONTEXT_KEY);
        ClientBehaviorHolder behaviorHolder = (ClientBehaviorHolder)parent;
        ValueExpression bindingExpr = null;
        Behavior behavior = null;
        if (null != this.owner.getBinding()) {
            bindingExpr = this.owner.getBinding().getValueExpression(ctx, Behavior.class);
            behavior = (Behavior)bindingExpr.getValue((ELContext)ctx);
        }
        if (null == behavior) {
            if (null != this.owner.getBehaviorId()) {
                behavior = ctx.getFacesContext().getApplication().createBehavior(this.owner.getBehaviorId());
                if (null == behavior) {
                    throw new TagException(this.owner.getTag(), "No Faces behavior defined for Id " + this.owner.getBehaviorId());
                }
                if (null != bindingExpr) {
                    bindingExpr.setValue((ELContext)ctx, (Object)behavior);
                }
            } else {
                throw new TagException(this.owner.getTag(), "No behaviorId defined");
            }
        }
        this.owner.setAttributes(ctx, behavior);
        if (behavior instanceof ClientBehavior) {
            behaviorHolder.addClientBehavior(this.getEventName(behaviorHolder), (ClientBehavior)behavior);
        }
    }

    public MetaRuleset createMetaRuleset(Class type) {
        Util.notNull("type", type);
        MetaRulesetImpl m = new MetaRulesetImpl(this.owner.getTag(), type);
        m = m.ignore("event");
        return m.ignore("binding").ignore("for");
    }

    public String getFor() {
        String result = null;
        TagAttribute attr = this.owner.getTagAttribute("for");
        if (null != attr) {
            result = attr.getValue();
        }
        return result;
    }

    private String getEventName(ClientBehaviorHolder holder) {
        String eventName = null != this.owner.getEvent() ? this.owner.getEvent().getValue() : holder.getDefaultEventName();
        if (null == eventName) {
            throw new TagException(this.owner.getTag(), "The event name is not defined");
        }
        return eventName;
    }
}

