/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.http.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import org.wildfly.common.Assert;
import org.wildfly.security.http.HttpAuthenticationException;
import org.wildfly.security.http.HttpServerAuthenticationMechanism;
import org.wildfly.security.http.HttpServerAuthenticationMechanismFactory;
import org.wildfly.security.http.util.ElytronMessages;

public final class AggregateServerMechanismFactory
implements HttpServerAuthenticationMechanismFactory {
    private final HttpServerAuthenticationMechanismFactory[] factories;

    public AggregateServerMechanismFactory(HttpServerAuthenticationMechanismFactory ... factories) {
        this.factories = (HttpServerAuthenticationMechanismFactory[])Assert.checkNotNullParam((String)"factories", (Object)factories);
    }

    public String[] getMechanismNames(Map<String, ?> properties) {
        LinkedHashSet names = new LinkedHashSet();
        for (HttpServerAuthenticationMechanismFactory current : this.factories) {
            if (current == null) continue;
            Collections.addAll(names, current.getMechanismNames(properties));
        }
        if (ElytronMessages.log.isTraceEnabled()) {
            ElytronMessages.log.tracef("%s provided by factories in %s: %s", HttpServerAuthenticationMechanismFactory.class.getSimpleName(), this.getClass().getSimpleName(), Arrays.toString(this.factories));
        }
        return names.toArray(new String[names.size()]);
    }

    public HttpServerAuthenticationMechanism createAuthenticationMechanism(String mechanismName, Map<String, ?> properties, CallbackHandler callbackHandler) throws HttpAuthenticationException {
        for (HttpServerAuthenticationMechanismFactory current : this.factories) {
            HttpServerAuthenticationMechanism mechanism;
            if (current == null || (mechanism = current.createAuthenticationMechanism(mechanismName, properties, callbackHandler)) == null) continue;
            return mechanism;
        }
        if (ElytronMessages.log.isTraceEnabled()) {
            ElytronMessages.log.tracef("Mechanism %s not provided as %s is not provided by factories in %s: %s", new Object[]{mechanismName, HttpServerAuthenticationMechanismFactory.class.getSimpleName(), this.getClass().getSimpleName(), Arrays.toString(this.factories)});
        }
        return null;
    }
}

