/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ee.cache.scheduler;

import java.util.AbstractMap;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import java.util.Spliterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.function.Consumer;
import org.wildfly.clustering.ee.cache.scheduler.ScheduledEntries;

public class SortedScheduledEntries<K, V extends Comparable<? super V>>
implements ScheduledEntries<K, V> {
    private final SortedSet<Map.Entry<K, V>> sorted;
    private final Map<K, V> entries = new ConcurrentHashMap();

    static <K, V extends Comparable<? super V>> Comparator<Map.Entry<K, V>> comparingByValue() {
        return new Comparator<Map.Entry<K, V>>(){

            @Override
            public int compare(Map.Entry<K, V> entry1, Map.Entry<K, V> entry2) {
                int result = ((Comparable)entry1.getValue()).compareTo(entry2.getValue());
                return result == 0 ? Integer.compare(entry1.getKey().hashCode(), entry2.getKey().hashCode()) : result;
            }
        };
    }

    public SortedScheduledEntries() {
        this(SortedScheduledEntries.comparingByValue());
    }

    public SortedScheduledEntries(Comparator<Map.Entry<K, V>> comparator) {
        this.sorted = new ConcurrentSkipListSet<Map.Entry<K, V>>(comparator);
    }

    @Override
    public boolean isSorted() {
        return true;
    }

    @Override
    public void add(K key, V value) {
        Comparable oldValue = (Comparable)this.entries.put(key, value);
        if (oldValue != null) {
            this.sorted.remove(new Entry<K, Comparable>(key, oldValue));
        }
        this.sorted.add(new Entry<K, V>(key, value));
    }

    @Override
    public void remove(K key) {
        Comparable value = (Comparable)this.entries.remove(key);
        if (value != null) {
            this.sorted.remove(new Entry<K, Comparable>(key, value));
        }
    }

    @Override
    public Map.Entry<K, V> peek() {
        try {
            return this.sorted.first();
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    @Override
    public Iterator<Map.Entry<K, V>> iterator() {
        final Iterator iterator = this.sorted.iterator();
        final Map<K, V> entries = this.entries;
        return new Iterator<Map.Entry<K, V>>(){
            private K current = null;

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public Map.Entry<K, V> next() {
                Map.Entry next = (Map.Entry)iterator.next();
                this.current = next.getKey();
                return next;
            }

            @Override
            public void remove() {
                iterator.remove();
                entries.remove(this.current);
            }
        };
    }

    @Override
    public void forEach(Consumer<? super Map.Entry<K, V>> action) {
        this.sorted.forEach(action);
    }

    @Override
    public Spliterator<Map.Entry<K, V>> spliterator() {
        return this.sorted.spliterator();
    }

    private static class Entry<K, V>
    extends AbstractMap.SimpleImmutableEntry<K, V> {
        private static final long serialVersionUID = -1818780078437540182L;

        Entry(K key, V value) {
            super(key, value);
        }

        @Override
        public boolean equals(Object object) {
            if (!(object instanceof Entry)) {
                return false;
            }
            Entry entry = (Entry)object;
            return this.getKey().equals(entry.getKey());
        }

        @Override
        public int hashCode() {
            return this.getKey().hashCode();
        }

        @Override
        public String toString() {
            return this.getKey().toString();
        }
    }
}

