/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.threads;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.jboss.as.threads.ManagedEnhancedQueueExecutor;
import org.jboss.as.threads.StopContextEventListener;
import org.jboss.as.threads.ThreadsLogger;
import org.jboss.as.threads.TimeSpec;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.threads.EnhancedQueueExecutor;

class EnhancedQueueExecutorService
implements Service<ManagedEnhancedQueueExecutor> {
    private final InjectedValue<ThreadFactory> threadFactoryValue = new InjectedValue();
    private ManagedEnhancedQueueExecutor executor;
    private int maxThreads;
    private int coreThreads;
    private TimeSpec keepAlive;
    private boolean allowCoreThreadTimeout;

    EnhancedQueueExecutorService(boolean allowCoreThreadTimeout, int maxThreads, int coreThreads, TimeSpec keepAlive) {
        this.maxThreads = maxThreads;
        this.coreThreads = coreThreads;
        this.keepAlive = keepAlive;
        this.allowCoreThreadTimeout = allowCoreThreadTimeout;
    }

    public synchronized void start(StartContext context) {
        TimeSpec keepAliveSpec = this.keepAlive;
        long keepAliveTime = keepAliveSpec == null ? Long.MAX_VALUE : keepAliveSpec.getUnit().toNanos(keepAliveSpec.getDuration());
        EnhancedQueueExecutor enhancedQueueExecutor = new EnhancedQueueExecutor.Builder().setMaximumPoolSize(this.maxThreads).setCorePoolSize(this.coreThreads > 0 ? this.coreThreads : this.maxThreads).setKeepAliveTime(keepAliveTime, TimeUnit.NANOSECONDS).setThreadFactory((ThreadFactory)this.threadFactoryValue.getValue()).allowCoreThreadTimeOut(this.allowCoreThreadTimeout).build();
        this.executor = new ManagedEnhancedQueueExecutor(enhancedQueueExecutor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(StopContext context) {
        ManagedEnhancedQueueExecutor executor;
        EnhancedQueueExecutorService enhancedQueueExecutorService = this;
        synchronized (enhancedQueueExecutorService) {
            executor = this.executor;
            this.executor = null;
        }
        context.asynchronous();
        executor.internalShutdown();
        executor.addShutdownListener(StopContextEventListener.getInstance(), context);
    }

    public synchronized ManagedEnhancedQueueExecutor getValue() throws IllegalStateException {
        ManagedEnhancedQueueExecutor value = this.executor;
        if (value == null) {
            throw ThreadsLogger.ROOT_LOGGER.enhancedQueueExecutorUninitialized();
        }
        return value;
    }

    Injector<ThreadFactory> getThreadFactoryInjector() {
        return this.threadFactoryValue;
    }

    synchronized void setMaxThreads(int maxThreads) {
        ManagedEnhancedQueueExecutor executor = this.executor;
        if (executor != null) {
            executor.setMaxThreads(maxThreads);
        }
        this.maxThreads = maxThreads;
    }

    synchronized void setCoreThreads(int coreThreads) {
        ManagedEnhancedQueueExecutor executor = this.executor;
        if (executor != null) {
            executor.setCoreThreads(coreThreads);
        }
        this.coreThreads = coreThreads;
    }

    synchronized void setKeepAlive(TimeSpec keepAlive) {
        this.keepAlive = keepAlive;
        ManagedEnhancedQueueExecutor executor = this.executor;
        if (executor != null) {
            executor.setKeepAlive(keepAlive);
        }
    }

    int getActiveCount() {
        ManagedEnhancedQueueExecutor executor = this.getValue();
        return executor.getActiveCount();
    }

    long getCompletedTaskCount() {
        ManagedEnhancedQueueExecutor executor = this.getValue();
        return executor.getCompletedTaskCount();
    }

    int getCurrentThreadCount() {
        ManagedEnhancedQueueExecutor executor = this.getValue();
        return executor.getCurrentThreadCount();
    }

    int getLargestPoolSize() {
        ManagedEnhancedQueueExecutor executor = this.getValue();
        return executor.getLargestPoolSize();
    }

    int getLargestThreadCount() {
        ManagedEnhancedQueueExecutor executor = this.getValue();
        return executor.getLargestThreadCount();
    }

    int getRejectedCount() {
        ManagedEnhancedQueueExecutor executor = this.getValue();
        return executor.getRejectedCount();
    }

    long getTaskCount() {
        ManagedEnhancedQueueExecutor executor = this.getValue();
        return executor.getTaskCount();
    }

    int getQueueSize() {
        ManagedEnhancedQueueExecutor executor = this.getValue();
        return executor.getQueueSize();
    }

    TimeUnit getKeepAliveUnit() {
        return this.keepAlive == null ? TimeSpec.DEFAULT_KEEPALIVE.getUnit() : this.keepAlive.getUnit();
    }
}

