/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands.messages;

import io.airlift.airline.Command;
import io.airlift.airline.Option;
import java.io.FileInputStream;
import java.io.InputStream;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import org.apache.activemq.artemis.cli.commands.ActionContext;
import org.apache.activemq.artemis.cli.commands.messages.DestAbstract;
import org.apache.activemq.artemis.cli.commands.messages.ProducerThread;
import org.apache.activemq.artemis.cli.factory.serialize.MessageSerializer;

@Command(name="producer", description="It will send messages to an instance")
public class Producer
extends DestAbstract {
    public static final String DEMO_TEXT = "demo.txt";
    @Option(name={"--non-persistent"}, description="It will send messages non persistently")
    boolean nonpersistent = false;
    @Option(name={"--message-size"}, description="Size of each byteMessage (The producer will use byte message on this case)")
    int messageSize = 0;
    @Option(name={"--message"}, description="Content of each textMessage (The producer will use text message on this case)")
    String message = null;
    @Option(name={"--text-size"}, description="Size of each textMessage (The producer will use text message on this case)")
    int textMessageSize;
    @Option(name={"--object-size"}, description="Size of each ObjectMessage (The producer will use object message on this case)")
    int objectSize;
    @Option(name={"--msgttl"}, description="TTL for each message")
    long msgTTL = 0L;
    @Option(name={"--group"}, description="Message Group to be used")
    String msgGroupID = null;
    @Option(name={"--data"}, description="Messages will be read form the specified file, other message options will be ignored.")
    String file = null;

    public boolean isNonpersistent() {
        return this.nonpersistent;
    }

    public Producer setNonpersistent(boolean nonpersistent) {
        this.nonpersistent = nonpersistent;
        return this;
    }

    public int getMessageSize() {
        return this.messageSize;
    }

    public Producer setMessageSize(int messageSize) {
        this.messageSize = messageSize;
        return this;
    }

    public String getMessage() {
        return this.message;
    }

    public Producer setMessage(String message) {
        this.message = message;
        return this;
    }

    public int getTextMessageSize() {
        return this.textMessageSize;
    }

    public Producer setTextMessageSize(int textMessageSize) {
        this.textMessageSize = textMessageSize;
        return this;
    }

    public int getObjectSize() {
        return this.objectSize;
    }

    public Producer setObjectSize(int objectSize) {
        this.objectSize = objectSize;
        return this;
    }

    public long getMsgTTL() {
        return this.msgTTL;
    }

    public Producer setMsgTTL(long msgTTL) {
        this.msgTTL = msgTTL;
        return this;
    }

    public String getMsgGroupID() {
        return this.msgGroupID;
    }

    public Producer setMsgGroupID(String msgGroupID) {
        this.msgGroupID = msgGroupID;
        return this;
    }

    public String getFile() {
        return this.file;
    }

    public Producer setFile(String file) {
        this.file = file;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object execute(ActionContext context) throws Exception {
        super.execute(context);
        ConnectionFactory factory = this.createConnectionFactory();
        try (Connection connection = factory.createConnection();){
            if (this.file != null) {
                Object in;
                MessageSerializer serializer;
                int messageCount;
                MessageProducer messageProducer;
                Session session;
                block39: {
                    session = connection.createSession(true, 0);
                    Destination dest = this.getDestination(session);
                    messageProducer = session.createProducer(dest);
                    messageProducer.setDeliveryMode(2);
                    messageCount = 0;
                    serializer = this.getMessageSerializer();
                    if (serializer != null) break block39;
                    System.err.println("Error. Unable to instantiate serializer class: " + serializer);
                    Object var10_27 = null;
                    return var10_27;
                }
                try {
                    in = new FileInputStream(this.file);
                }
                catch (Exception e) {
                    System.err.println("Error: Unable to open file for reading\n" + e.getMessage());
                    Object var12_35 = null;
                    if (connection != null) {
                        if (var4_4 != null) {
                            try {
                                connection.close();
                            }
                            catch (Throwable throwable) {
                                var4_4.addSuppressed(throwable);
                            }
                        } else {
                            connection.close();
                        }
                    }
                    return var12_35;
                }
                try {
                    serializer.setInput((InputStream)in, session);
                    serializer.start();
                    Message message = serializer.read();
                    while (message != null) {
                        messageProducer.send(message);
                        message = serializer.read();
                        ++messageCount;
                    }
                    session.commit();
                    serializer.stop();
                }
                catch (Exception e) {
                    System.err.println("Error occurred during import.  Rolling back.");
                    session.rollback();
                    e.printStackTrace();
                    in = 0;
                    return in;
                }
                System.out.println("Sent " + messageCount + " Messages.");
                Integer e = messageCount;
                return e;
            }
            ProducerThread[] threadsArray = new ProducerThread[this.threads];
            for (int i = 0; i < this.threads; ++i) {
                void var7_13;
                if (this.txBatchSize > 0) {
                    Session session = connection.createSession(true, 0);
                } else {
                    Session object = connection.createSession(false, 1);
                }
                Destination dest = this.getDestination((Session)var7_13);
                threadsArray[i] = new ProducerThread((Session)var7_13, dest, i);
                threadsArray[i].setVerbose(this.verbose).setSleep(this.sleep).setPersistent(!this.nonpersistent).setMessageSize(this.messageSize).setTextMessageSize(this.textMessageSize).setMessage(this.message).setObjectSize(this.objectSize).setMsgTTL(this.msgTTL).setMsgGroupID(this.msgGroupID).setTransactionBatchSize(this.txBatchSize).setMessageCount(this.messageCount);
            }
            for (ProducerThread thread : threadsArray) {
                thread.start();
            }
            int messagesProduced = 0;
            for (ProducerThread thread : threadsArray) {
                thread.join();
                messagesProduced += thread.getSentCount();
            }
            Integer n = messagesProduced;
            return n;
        }
    }
}

