/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.txn.ee.concurrency;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Map;
import javax.enterprise.concurrent.ContextService;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.as.ee.concurrent.handle.ContextHandleFactory;
import org.jboss.as.ee.concurrent.handle.ResetContextHandle;
import org.jboss.as.ee.concurrent.handle.SetupContextHandle;
import org.jboss.as.server.deployment.DelegatingSupplier;
import org.jboss.as.txn.logging.TransactionLogger;

public class TransactionLeakContextHandleFactory
implements ContextHandleFactory {
    public static final String NAME = "TRANSACTION_LEAK";
    private final DelegatingSupplier<TransactionManager> transactionManager = new DelegatingSupplier();

    public SetupContextHandle saveContext(ContextService contextService, Map<String, String> contextObjectProperties) {
        return new TransactionLeakSetupContextHandle((TransactionManager)this.transactionManager.get());
    }

    public String getName() {
        return NAME;
    }

    public int getChainPriority() {
        return 600;
    }

    public void writeSetupContextHandle(SetupContextHandle contextHandle, ObjectOutputStream out) throws IOException {
    }

    public SetupContextHandle readSetupContextHandle(ObjectInputStream in) throws IOException, ClassNotFoundException {
        return new TransactionLeakSetupContextHandle((TransactionManager)this.transactionManager.get());
    }

    public DelegatingSupplier<TransactionManager> getTransactionManagerSupplier() {
        return this.transactionManager;
    }

    private static class TransactionLeakResetContextHandle
    implements ResetContextHandle {
        private static final long serialVersionUID = -1726741825781759990L;
        private final TransactionManager transactionManager;
        private final Transaction transactionOnSetup;

        private TransactionLeakResetContextHandle(TransactionManager transactionManager, Transaction transactionOnSetup) {
            this.transactionManager = transactionManager;
            this.transactionOnSetup = transactionOnSetup;
        }

        /*
         * Loose catch block
         */
        public void reset() {
            block16: {
                if (this.transactionManager != null) {
                    try {
                        Transaction transactionOnReset = this.transactionManager.getTransaction();
                        if (transactionOnReset == null || transactionOnReset.equals(this.transactionOnSetup)) break block16;
                        switch (transactionOnReset.getStatus()) {
                            case 0: 
                            case 1: 
                            case 2: 
                            case 7: 
                            case 8: 
                            case 9: {
                                TransactionLogger.ROOT_LOGGER.rollbackOfTransactionStartedInEEConcurrentInvocation();
                                this.transactionManager.rollback();
                                try {
                                    this.transactionManager.suspend();
                                }
                                catch (Throwable e) {
                                    TransactionLogger.ROOT_LOGGER.failedToSuspendTransaction(e);
                                }
                                break;
                                catch (Throwable e) {
                                    try {
                                        TransactionLogger.ROOT_LOGGER.failedToRollbackTransaction(e);
                                    }
                                    catch (Throwable throwable) {
                                        try {
                                            this.transactionManager.suspend();
                                        }
                                        catch (Throwable e2) {
                                            TransactionLogger.ROOT_LOGGER.failedToSuspendTransaction(e2);
                                        }
                                        throw throwable;
                                    }
                                    try {
                                        this.transactionManager.suspend();
                                    }
                                    catch (Throwable e3) {
                                        TransactionLogger.ROOT_LOGGER.failedToSuspendTransaction(e3);
                                    }
                                    break;
                                }
                            }
                        }
                    }
                    catch (SystemException e) {
                        TransactionLogger.ROOT_LOGGER.systemErrorWhileCheckingForTransactionLeak(e);
                    }
                }
            }
        }

        public String getFactoryName() {
            return TransactionLeakContextHandleFactory.NAME;
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            throw TransactionLogger.ROOT_LOGGER.serializationMustBeHandledByTheFactory();
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            throw TransactionLogger.ROOT_LOGGER.serializationMustBeHandledByTheFactory();
        }
    }

    private static class TransactionLeakSetupContextHandle
    implements SetupContextHandle {
        private static final long serialVersionUID = -8142799455606311295L;
        private final TransactionManager transactionManager;

        private TransactionLeakSetupContextHandle(TransactionManager transactionManager) {
            this.transactionManager = transactionManager;
        }

        public ResetContextHandle setup() throws IllegalStateException {
            Transaction transactionOnSetup = null;
            if (this.transactionManager != null) {
                try {
                    transactionOnSetup = this.transactionManager.getTransaction();
                }
                catch (SystemException e) {
                    throw new IllegalStateException(e);
                }
            }
            return new TransactionLeakResetContextHandle(this.transactionManager, transactionOnSetup);
        }

        public String getFactoryName() {
            return TransactionLeakContextHandleFactory.NAME;
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            throw TransactionLogger.ROOT_LOGGER.serializationMustBeHandledByTheFactory();
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            throw TransactionLogger.ROOT_LOGGER.serializationMustBeHandledByTheFactory();
        }
    }
}

