/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.logging.Log;
import org.jgroups.protocols.Bundler;
import org.jgroups.protocols.TP;
import org.jgroups.util.ByteArrayDataOutputStream;
import org.jgroups.util.Util;

public class NoBundler
implements Bundler {
    protected TP transport;
    protected Log log;

    @Override
    public int size() {
        return 0;
    }

    @Override
    public void init(TP transport) {
        this.transport = transport;
        this.log = transport.getLog();
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public void send(Message msg) throws Exception {
        ByteArrayDataOutputStream out = new ByteArrayDataOutputStream((int)(msg.size() + 10L));
        this.sendSingleMessage(msg, out);
    }

    protected void sendSingleMessage(Message msg, ByteArrayDataOutputStream output) throws Exception {
        Address dest = msg.getDest();
        output.position(0);
        Util.writeMessage(msg, output, dest == null);
        this.transport.doSend(output.buffer(), 0, output.position(), dest);
        if (this.transport.statsEnabled()) {
            this.transport.incrNumSingleMsgsSent(1);
        }
    }
}

