/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.logging;

import java.io.IOException;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Locale;
import javax.naming.NamingException;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.persistence.jdbc.logging.Log;
import org.infinispan.persistence.spi.PersistenceException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;

public class Log_$logger
extends DelegatingBasicLogger
implements Log,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;
    private static final String errorMarshallingObject = "ISPN000065: Exception while marshalling object: %s";
    private static final String failedClearingJdbcCacheStore = "ISPN008001: Failed clearing cache store";
    private static final String sqlFailureIntegratingState = "ISPN008003: SQL failure while integrating state into store";
    private static final String ioErrorUnmarshalling = "ISPN008009: I/O error while unmarshalling from stream";
    private static final String unexpectedClassNotFoundException = "ISPN008010: *UNEXPECTED* ClassNotFoundException.";
    private static final String errorCreatingTable = "ISPN008011: Error while creating table; used DDL statement: '%s'";
    private static final String connectionInJndiNotFound = "ISPN008015: Could not find a connection in jndi under the name '%s'";
    private static final String namingExceptionLookingUpConnection = "ISPN008016: Could not lookup connection with datasource %s";
    private static final String failedClosingNamingCtx = "ISPN008017: Failed to close naming context.";
    private static final String sqlFailureRetrievingConnection = "ISPN008018: Sql failure retrieving connection from datasource";
    private static final String sqlFailureClosingConnection = "ISPN008019: Issues while closing connection %s";
    private static final String sqlFailureUnexpected = "ISPN008022: Unexpected sql failure";
    private static final String failureClosingConnection = "ISPN008023: Failure while closing the connection to the database";
    private static final String sqlFailureStoringKey = "ISPN008024: Error while storing string key to database; key: '%s'";
    private static final String sqlFailureRemovingKeys = "ISPN008025: Error while removing string keys from database";
    private static final String invalidKey2StringMapper = "ISPN008026: In order for JdbcStringBasedStore to support %s, the Key2StringMapper needs to implement TwoWayKey2StringMapper. You should either make %s implement TwoWayKey2StringMapper or disable the sql. See [https://jira.jboss.org/browse/ISPN-579] for more details.";
    private static final String sqlFailureReadingKey = "ISPN008027: SQL error while fetching stored entry with key: %s, lockingKey: %s";
    private static final String tableManipulationAttributeNotSet = "ISPN008028: Attribute '%s' has not been set";
    private static final String missingConnectionFactory = "ISPN008029: A ConnectionFactory has not been specified for this store";
    private static final String unmanagedConnectionFactory = "ISPN008030: Cannot specify a ConnectionFactory and manageConnectionFactory at the same time";
    private static final String sqlFailureTxCommit = "ISPN008031: Error committing JDBC transaction";
    private static final String sqlFailureTxRollback = "ISPN008032: Error during rollback of JDBC transaction";
    private static final String prepareTxFailure = "ISPN008033: Exception encountered when preparing JDBC store Tx";
    private static final String twoWayKey2StringMapperIsMissing = "ISPN008036: Unable to notify the PurgeListener of expired cache entries as the configured key2StringMapper does not implement %s";
    private static final String sqlFailureWritingBatch = "ISPN008037: Error while writing entries in batch to the database:";
    private static final String sqlFailureDeletingBatch = "ISPN008038: Error whilst removing keys in batch from the database. Keys: %s";
    private static final String existingStoreNoSegmentation = "ISPN008039: The existing store was created without segmentation enabled";
    private static final String existingStoreSegmentMismatch = "ISPN008040: The existing store was created with %d segments configured, but the cache is configured with %d";
    private static final String sqlFailureMetaRetrieval = "ISPN008041: Error retrieving JDBC metadata";

    public Log_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void errorMarshallingObject(Throwable ioe, Object obj) {
        this.log.logf(FQCN, Logger.Level.ERROR, ioe, this.errorMarshallingObject$str(), obj);
    }

    protected String errorMarshallingObject$str() {
        return errorMarshallingObject;
    }

    @Override
    public final void failedClearingJdbcCacheStore(Exception e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.failedClearingJdbcCacheStore$str(), new Object[0]);
    }

    protected String failedClearingJdbcCacheStore$str() {
        return failedClearingJdbcCacheStore;
    }

    @Override
    public final void sqlFailureIntegratingState(SQLException e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.sqlFailureIntegratingState$str(), new Object[0]);
    }

    protected String sqlFailureIntegratingState$str() {
        return sqlFailureIntegratingState;
    }

    @Override
    public final void ioErrorUnmarshalling(IOException e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.ioErrorUnmarshalling$str(), new Object[0]);
    }

    protected String ioErrorUnmarshalling$str() {
        return ioErrorUnmarshalling;
    }

    @Override
    public final void unexpectedClassNotFoundException(ClassNotFoundException e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.unexpectedClassNotFoundException$str(), new Object[0]);
    }

    protected String unexpectedClassNotFoundException$str() {
        return unexpectedClassNotFoundException;
    }

    @Override
    public final void errorCreatingTable(String sql, SQLException e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.errorCreatingTable$str(), (Object)sql);
    }

    protected String errorCreatingTable$str() {
        return errorCreatingTable;
    }

    @Override
    public final void connectionInJndiNotFound(String dataSourceName) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.connectionInJndiNotFound$str(), (Object)dataSourceName);
    }

    protected String connectionInJndiNotFound$str() {
        return connectionInJndiNotFound;
    }

    @Override
    public final void namingExceptionLookingUpConnection(String dataSourceName, NamingException e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.namingExceptionLookingUpConnection$str(), (Object)dataSourceName);
    }

    protected String namingExceptionLookingUpConnection$str() {
        return namingExceptionLookingUpConnection;
    }

    @Override
    public final void failedClosingNamingCtx(NamingException e) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)e, this.failedClosingNamingCtx$str(), new Object[0]);
    }

    protected String failedClosingNamingCtx$str() {
        return failedClosingNamingCtx;
    }

    @Override
    public final void sqlFailureRetrievingConnection(SQLException e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.sqlFailureRetrievingConnection$str(), new Object[0]);
    }

    protected String sqlFailureRetrievingConnection$str() {
        return sqlFailureRetrievingConnection;
    }

    @Override
    public final void sqlFailureClosingConnection(Connection conn, SQLException e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.sqlFailureClosingConnection$str(), (Object)conn);
    }

    protected String sqlFailureClosingConnection$str() {
        return sqlFailureClosingConnection;
    }

    @Override
    public final void sqlFailureUnexpected(SQLException e) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)e, this.sqlFailureUnexpected$str(), new Object[0]);
    }

    protected String sqlFailureUnexpected$str() {
        return sqlFailureUnexpected;
    }

    @Override
    public final void failureClosingConnection(SQLException e) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)e, this.failureClosingConnection$str(), new Object[0]);
    }

    protected String failureClosingConnection$str() {
        return failureClosingConnection;
    }

    @Override
    public final void sqlFailureStoringKey(String lockingKey, SQLException e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.sqlFailureStoringKey$str(), (Object)lockingKey);
    }

    protected String sqlFailureStoringKey$str() {
        return sqlFailureStoringKey;
    }

    @Override
    public final void sqlFailureRemovingKeys(SQLException e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.sqlFailureRemovingKeys$str(), new Object[0]);
    }

    protected String sqlFailureRemovingKeys$str() {
        return sqlFailureRemovingKeys;
    }

    @Override
    public final void invalidKey2StringMapper(String where, String className) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.invalidKey2StringMapper$str(), (Object)where, (Object)className);
    }

    protected String invalidKey2StringMapper$str() {
        return invalidKey2StringMapper;
    }

    @Override
    public final void sqlFailureReadingKey(Object key, String lockingKey, SQLException e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.sqlFailureReadingKey$str(), key, (Object)lockingKey);
    }

    protected String sqlFailureReadingKey$str() {
        return sqlFailureReadingKey;
    }

    protected String tableManipulationAttributeNotSet$str() {
        return tableManipulationAttributeNotSet;
    }

    @Override
    public final CacheConfigurationException tableManipulationAttributeNotSet(String name) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.tableManipulationAttributeNotSet$str(), name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String missingConnectionFactory$str() {
        return missingConnectionFactory;
    }

    @Override
    public final CacheConfigurationException missingConnectionFactory() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.missingConnectionFactory$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unmanagedConnectionFactory$str() {
        return unmanagedConnectionFactory;
    }

    @Override
    public final CacheConfigurationException unmanagedConnectionFactory() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.unmanagedConnectionFactory$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void sqlFailureTxCommit(SQLException e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.sqlFailureTxCommit$str(), new Object[0]);
    }

    protected String sqlFailureTxCommit$str() {
        return sqlFailureTxCommit;
    }

    @Override
    public final void sqlFailureTxRollback(SQLException e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.sqlFailureTxRollback$str(), new Object[0]);
    }

    protected String sqlFailureTxRollback$str() {
        return sqlFailureTxRollback;
    }

    protected String prepareTxFailure$str() {
        return prepareTxFailure;
    }

    @Override
    public final PersistenceException prepareTxFailure(Throwable e) {
        PersistenceException result = new PersistenceException(String.format(this.getLoggingLocale(), this.prepareTxFailure$str(), new Object[0]), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void twoWayKey2StringMapperIsMissing(String className) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.twoWayKey2StringMapperIsMissing$str(), (Object)className);
    }

    protected String twoWayKey2StringMapperIsMissing$str() {
        return twoWayKey2StringMapperIsMissing;
    }

    protected String sqlFailureWritingBatch$str() {
        return sqlFailureWritingBatch;
    }

    @Override
    public final PersistenceException sqlFailureWritingBatch(Throwable e) {
        PersistenceException result = new PersistenceException(String.format(this.getLoggingLocale(), this.sqlFailureWritingBatch$str(), new Object[0]), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String sqlFailureDeletingBatch$str() {
        return sqlFailureDeletingBatch;
    }

    @Override
    public final PersistenceException sqlFailureDeletingBatch(Iterable<Object> keys, Exception e) {
        PersistenceException result = new PersistenceException(String.format(this.getLoggingLocale(), this.sqlFailureDeletingBatch$str(), keys), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String existingStoreNoSegmentation$str() {
        return existingStoreNoSegmentation;
    }

    @Override
    public final CacheConfigurationException existingStoreNoSegmentation() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.existingStoreNoSegmentation$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String existingStoreSegmentMismatch$str() {
        return existingStoreSegmentMismatch;
    }

    @Override
    public final CacheConfigurationException existingStoreSegmentMismatch(int existing, int cache) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.existingStoreSegmentMismatch$str(), existing, cache));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void sqlFailureMetaRetrieval(SQLException e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.sqlFailureMetaRetrieval$str(), new Object[0]);
    }

    protected String sqlFailureMetaRetrieval$str() {
        return sqlFailureMetaRetrieval;
    }
}

