/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.entries;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.commons.util.Util;
import org.infinispan.container.entries.ImmortalCacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.InternalCacheValue;
import org.infinispan.metadata.EmbeddedMetadata;
import org.infinispan.metadata.Metadata;
import org.infinispan.metadata.impl.PrivateMetadata;

public class ImmortalCacheValue
implements InternalCacheValue,
Cloneable {
    public Object value;
    protected PrivateMetadata internalMetadata;

    public ImmortalCacheValue(Object value) {
        this(value, null);
    }

    protected ImmortalCacheValue(Object value, PrivateMetadata internalMetadata) {
        this.value = value;
        this.internalMetadata = internalMetadata;
    }

    public InternalCacheEntry<?, ?> toInternalCacheEntry(Object key) {
        return new ImmortalCacheEntry(key, this.value, this.internalMetadata);
    }

    public final Object setValue(Object value) {
        Object old = this.value;
        this.value = value;
        return old;
    }

    public Object getValue() {
        return this.value;
    }

    @Override
    public boolean isExpired(long now) {
        return false;
    }

    @Override
    public boolean canExpire() {
        return false;
    }

    @Override
    public long getCreated() {
        return -1L;
    }

    @Override
    public long getLastUsed() {
        return -1L;
    }

    @Override
    public long getLifespan() {
        return -1L;
    }

    @Override
    public long getMaxIdle() {
        return -1L;
    }

    @Override
    public long getExpiryTime() {
        return -1L;
    }

    @Override
    public Metadata getMetadata() {
        return new EmbeddedMetadata.Builder().lifespan(this.getLifespan()).maxIdle(this.getMaxIdle()).build();
    }

    @Override
    public final PrivateMetadata getInternalMetadata() {
        return this.internalMetadata;
    }

    @Override
    public final void setInternalMetadata(PrivateMetadata internalMetadata) {
        this.internalMetadata = internalMetadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ImmortalCacheValue)) {
            return false;
        }
        ImmortalCacheValue that = (ImmortalCacheValue)o;
        return Objects.equals(this.value, that.value) && Objects.equals(this.internalMetadata, that.internalMetadata);
    }

    public int hashCode() {
        int result = Objects.hashCode(this.value);
        result = 31 * result + Objects.hashCode(this.internalMetadata);
        return result;
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder(this.getClass().getSimpleName());
        builder.append('{');
        this.appendFieldsToString(builder);
        return builder.append('}').toString();
    }

    public ImmortalCacheValue clone() {
        try {
            return (ImmortalCacheValue)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Should never happen", e);
        }
    }

    protected void appendFieldsToString(StringBuilder builder) {
        builder.append("value=").append(Util.toStr((Object)this.value));
        builder.append(", internalMetadata=").append(this.internalMetadata);
    }

    public static class Externalizer
    extends AbstractExternalizer<ImmortalCacheValue> {
        public void writeObject(ObjectOutput output, ImmortalCacheValue icv) throws IOException {
            output.writeObject(icv.value);
            output.writeObject(icv.internalMetadata);
        }

        public ImmortalCacheValue readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            Object value = input.readObject();
            PrivateMetadata internalMetadata = (PrivateMetadata)input.readObject();
            return new ImmortalCacheValue(value, internalMetadata);
        }

        public Integer getId() {
            return 11;
        }

        public Set<Class<? extends ImmortalCacheValue>> getTypeClasses() {
            return Collections.singleton(ImmortalCacheValue.class);
        }
    }
}

