/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3.remote;

import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.util.function.ToIntFunction;
import org.jboss.remoting3.MessageCancelledException;
import org.jboss.remoting3.MessageOutputStream;
import org.jboss.remoting3.NotOpenException;
import org.jboss.remoting3._private.Messages;
import org.jboss.remoting3.remote.RemoteConnectionChannel;
import org.xnio.BrokenPipeException;
import org.xnio.Connection;
import org.xnio.IoUtils;
import org.xnio.Pooled;
import org.xnio.streams.BufferPipeOutputStream;

final class OutboundMessage
extends MessageOutputStream {
    final short messageId;
    final RemoteConnectionChannel channel;
    final BufferPipeOutputStream pipeOutputStream;
    final int maximumWindow;
    final int ackTimeout;
    int window;
    boolean closeCalled;
    boolean closeReceived;
    boolean cancelled;
    boolean cancelSent;
    boolean eofSent;
    boolean released;
    long remaining;
    final BufferPipeOutputStream.BufferWriter bufferWriter = new BufferPipeOutputStream.BufferWriter(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Pooled<ByteBuffer> getBuffer(boolean firstBuffer) throws IOException {
            Pooled<ByteBuffer> pooled = OutboundMessage.this.allocate((byte)48);
            boolean ok = false;
            try {
                ByteBuffer buffer = pooled.getResource();
                buffer.limit(buffer.limit() - 4);
                buffer.put(firstBuffer ? (byte)2 : 0);
                int windowPlusHeader = OutboundMessage.this.maximumWindow + 8;
                if (buffer.remaining() > windowPlusHeader) {
                    buffer.limit(windowPlusHeader);
                }
                ok = true;
                Pooled<ByteBuffer> pooled2 = pooled;
                return pooled2;
            }
            finally {
                if (!ok) {
                    pooled.free();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void accept(Pooled<ByteBuffer> pooledBuffer, boolean eof) throws IOException {
            boolean ok = false;
            try {
                boolean timeoutExpired;
                boolean intr;
                boolean sendCancel;
                Connection connection;
                ByteBuffer buffer;
                block24: {
                    assert (Thread.holdsLock(OutboundMessage.this.pipeOutputStream));
                    if (OutboundMessage.this.closeCalled) {
                        throw new NotOpenException(this + ": message was closed asynchronously by another thread");
                    }
                    if (OutboundMessage.this.cancelSent) {
                        throw new MessageCancelledException(this + ": message was cancelled");
                    }
                    if (OutboundMessage.this.closeReceived) {
                        throw new BrokenPipeException(this + ": remote side closed the message stream");
                    }
                    if (eof) {
                        OutboundMessage.this.closeCalled = true;
                        OutboundMessage.this.pipeOutputStream.notifyAll();
                    }
                    buffer = pooledBuffer.getResource();
                    connection = OutboundMessage.this.channel.getRemoteConnection().getConnection();
                    boolean badMsgSize = OutboundMessage.this.channel.getConnectionHandler().isFaultyMessageSize();
                    int msgSize = badMsgSize ? buffer.remaining() : buffer.remaining() - 8;
                    sendCancel = OutboundMessage.this.cancelled && !OutboundMessage.this.cancelSent;
                    intr = false;
                    timeoutExpired = false;
                    if (msgSize > 0 && !sendCancel) {
                        do {
                            block25: {
                                int currentWindow = OutboundMessage.this.window;
                                if (OutboundMessage.this.window >= msgSize) {
                                    OutboundMessage.this.window -= msgSize;
                                    if (Messages.log.isTraceEnabled()) {
                                        Messages.log.tracef("Outbound message ID %04x: message window is open (%d-%d=%d remaining), proceeding with send", OutboundMessage.this.getActualId(), OutboundMessage.this.window + msgSize, msgSize, OutboundMessage.this.window);
                                    }
                                    break block24;
                                }
                                try {
                                    Messages.log.tracef("Outbound message ID %04x: message window is closed, waiting", OutboundMessage.this.getActualId());
                                    OutboundMessage.this.pipeOutputStream.wait(OutboundMessage.this.ackTimeout, 0);
                                    if (OutboundMessage.this.window == currentWindow) {
                                        timeoutExpired = true;
                                    }
                                    break block25;
                                }
                                catch (InterruptedException e) {
                                    OutboundMessage.this.cancelled = true;
                                    intr = true;
                                }
                                break block24;
                            }
                            if (OutboundMessage.this.closeReceived) {
                                throw new BrokenPipeException(this + ": remote side closed the message stream");
                            }
                            if (!OutboundMessage.this.closeCalled || eof) continue;
                            throw new NotOpenException(this + ": message was closed asynchronously by another thread");
                        } while (!OutboundMessage.this.cancelSent);
                        throw new MessageCancelledException(this + ": message was cancelled");
                    }
                }
                if (eof || sendCancel || intr || timeoutExpired) {
                    OutboundMessage.this.eofSent = true;
                    buffer.put(7, (byte)(buffer.get(7) | 1));
                    Messages.log.tracef("Outbound message ID %04x: sending message (with EOF) (%s) to %s", OutboundMessage.this.getActualId(), (Object)buffer, (Object)connection);
                    if (!OutboundMessage.this.channel.getConnectionHandler().isMessageClose()) {
                        OutboundMessage.this.channel.free(OutboundMessage.this);
                    }
                    if (!OutboundMessage.this.released) {
                        OutboundMessage.this.released = true;
                        OutboundMessage.this.channel.closeOutboundMessage();
                    }
                }
                if (sendCancel || intr || timeoutExpired) {
                    OutboundMessage.this.cancelSent = true;
                    buffer.put(7, (byte)(buffer.get(7) | 4));
                    buffer.limit(8);
                    Messages.log.tracef("Outbound message ID %04x: message includes cancel flag", OutboundMessage.this.getActualId());
                }
                if (timeoutExpired) {
                    OutboundMessage.this.remoteClosed();
                }
                OutboundMessage.this.channel.getRemoteConnection().send(pooledBuffer);
                ok = true;
                if (intr) {
                    Thread.currentThread().interrupt();
                    throw new InterruptedIOException(this + ": interrupted on write (message cancelled)");
                }
                if (timeoutExpired) {
                    throw new IOException(this + ": cancelled because ack timeout has expired, no acks for this message received from client within " + OutboundMessage.this.ackTimeout + " milliseconds");
                }
            }
            finally {
                if (!ok) {
                    pooledBuffer.free();
                }
            }
        }

        @Override
        public void flush() throws IOException {
            Messages.log.tracef("Outbound message ID %04x: flushing message channel", OutboundMessage.this.getActualId());
        }
    };
    static final ToIntFunction<OutboundMessage> INDEXER = OutboundMessage::getActualId;

    OutboundMessage(short messageId, RemoteConnectionChannel channel, int window, long maxOutboundMessageSize, int ackTimeout) {
        this.messageId = messageId;
        this.channel = channel;
        this.window = this.maximumWindow = window;
        this.ackTimeout = ackTimeout;
        this.remaining = maxOutboundMessageSize;
        try {
            this.pipeOutputStream = new BufferPipeOutputStream(this.bufferWriter);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    int getActualId() {
        return this.messageId & 0xFFFF;
    }

    Pooled<ByteBuffer> allocate(byte protoId) {
        Pooled<ByteBuffer> pooled = this.channel.allocate(protoId);
        ByteBuffer buffer = pooled.getResource();
        buffer.putShort(this.messageId);
        return pooled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void acknowledge(int count) {
        BufferPipeOutputStream bufferPipeOutputStream = this.pipeOutputStream;
        synchronized (bufferPipeOutputStream) {
            if (Messages.log.isTraceEnabled()) {
                Messages.log.tracef("%s: acknowledged %d bytes", (Object)this, (Object)count);
            }
            this.window += count;
            this.pipeOutputStream.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remoteClosed() {
        BufferPipeOutputStream bufferPipeOutputStream = this.pipeOutputStream;
        synchronized (bufferPipeOutputStream) {
            this.closeReceived = true;
            Pooled<ByteBuffer> pooled = this.pipeOutputStream.breakPipe();
            if (pooled != null) {
                pooled.free();
            }
            if (!this.eofSent && this.channel.getConnectionHandler().isMessageClose()) {
                this.eofSent = true;
                pooled = this.allocate((byte)48);
                boolean ok = false;
                try {
                    ByteBuffer buffer = pooled.getResource();
                    buffer.put((byte)1);
                    buffer.flip();
                    this.channel.getRemoteConnection().send(pooled);
                    ok = true;
                }
                finally {
                    if (!ok) {
                        pooled.free();
                    }
                }
            }
            this.channel.free(this);
            if (!this.released) {
                this.released = true;
                this.channel.closeOutboundMessage();
            }
            this.pipeOutputStream.notifyAll();
        }
    }

    @Override
    public void write(int b) throws IOException {
        block3: {
            try {
                if (this.remaining > 1L) {
                    this.pipeOutputStream.write(b);
                    --this.remaining;
                    break block3;
                }
                throw this.overrun();
            }
            catch (IOException e) {
                this.cancel();
                throw e;
            }
        }
    }

    private IOException overrun() {
        try {
            IOException iOException = new IOException(this + ": maximum message size overrun");
            return iOException;
        }
        finally {
            this.cancel();
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        try {
            this.write(b, 0, b.length);
        }
        catch (IOException e) {
            this.cancel();
            throw e;
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        try {
            if ((long)len > this.remaining) {
                throw this.overrun();
            }
            this.pipeOutputStream.write(b, off, len);
            this.remaining -= (long)len;
        }
        catch (IOException e) {
            this.cancel();
            throw e;
        }
    }

    @Override
    public void flush() throws IOException {
        try {
            this.pipeOutputStream.flush();
        }
        catch (IOException e) {
            this.cancel();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            BufferPipeOutputStream bufferPipeOutputStream = this.pipeOutputStream;
            synchronized (bufferPipeOutputStream) {
                this.pipeOutputStream.notifyAll();
                this.pipeOutputStream.close();
            }
        }
        catch (IOException e) {
            this.cancel();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MessageOutputStream cancel() {
        BufferPipeOutputStream bufferPipeOutputStream = this.pipeOutputStream;
        synchronized (bufferPipeOutputStream) {
            this.cancelled = true;
            this.pipeOutputStream.notifyAll();
            IoUtils.safeClose((Closeable)this.pipeOutputStream);
            return this;
        }
    }

    public String toString() {
        return String.format("Outbound message ID %04x on %s", this.getActualId(), this.channel);
    }

    void dumpState(StringBuilder b) {
        b.append("            ").append(String.format("Outbound message ID %04x, window %d of %d\n", this.getActualId(), this.window, this.maximumWindow));
        b.append("            ").append("* flags: ");
        if (this.cancelled) {
            b.append("cancelled ");
        }
        if (this.cancelSent) {
            b.append("cancel-sent ");
        }
        if (this.closeReceived) {
            b.append("close-received ");
        }
        if (this.closeCalled) {
            b.append("closed-called ");
        }
        if (this.eofSent) {
            b.append("eof-sent ");
        }
        b.append('\n');
    }
}

